/*
 * Decompiled with CFR 0.152.
 */
package com.qualifiedcactus.sqlObjectMapper.fromRs;

import com.qualifiedcactus.sqlObjectMapper.SqlObjectMapperException;
import java.sql.ResultSet;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0003\u0014\u0015\u0016B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/qualifiedcactus/sqlObjectMapper/fromRs/IdMapping;", "", "idColumnNames", "", "", "(Ljava/util/List;)V", "getIdColumnNames", "()Ljava/util/List;", "noId", "", "getNoId", "()Z", "fromResultSet", "Lcom/qualifiedcactus/sqlObjectMapper/fromRs/IdMapping$IdValue;", "resultSet", "Ljava/sql/ResultSet;", "toCompositeId", "Lcom/qualifiedcactus/sqlObjectMapper/fromRs/IdMapping$CompositeIdValue;", "toSimpleId", "Lcom/qualifiedcactus/sqlObjectMapper/fromRs/IdMapping$SimpleIdValue;", "CompositeIdValue", "IdValue", "SimpleIdValue", "sqlObjectMapper"})
public final class IdMapping {
    @NotNull
    private final List<String> idColumnNames;
    private final boolean noId;

    public IdMapping(@NotNull List<String> idColumnNames) {
        Intrinsics.checkNotNullParameter(idColumnNames, (String)"idColumnNames");
        this.idColumnNames = idColumnNames;
        this.noId = this.idColumnNames.isEmpty();
    }

    @NotNull
    public final List<String> getIdColumnNames() {
        return this.idColumnNames;
    }

    public final boolean getNoId() {
        return this.noId;
    }

    @Nullable
    public final IdValue fromResultSet(@NotNull ResultSet resultSet) {
        IdValue idValue;
        Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
        if (this.noId) {
            throw new IllegalStateException("Internal Error: invalid operation");
        }
        if (this.idColumnNames.size() == 1) {
            idValue = this.toSimpleId(resultSet);
        } else if (this.idColumnNames.size() > 1) {
            idValue = this.toCompositeId(resultSet);
        } else {
            throw new SqlObjectMapperException("No ID columns specified");
        }
        return idValue;
    }

    private final SimpleIdValue toSimpleId(ResultSet resultSet) {
        Object idValue = resultSet.getObject((String)CollectionsKt.first(this.idColumnNames));
        return idValue == null ? null : new SimpleIdValue(idValue);
    }

    private final CompositeIdValue toCompositeId(ResultSet resultSet) {
        Object[] idValues = new Object[this.idColumnNames.size()];
        boolean allNull = false;
        int n = this.idColumnNames.size();
        for (int i = 0; i < n; ++i) {
            Object object;
            Object id = object = resultSet.getObject(this.idColumnNames.get(i));
            boolean bl = false;
            idValues[i] = id;
            allNull = allNull || id == null;
        }
        return allNull ? null : new CompositeIdValue(idValues);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\bf\u0018\u00002\u00020\u0001\u00a8\u0006\u0002"}, d2={"Lcom/qualifiedcactus/sqlObjectMapper/fromRs/IdMapping$IdValue;", "", "sqlObjectMapper"})
    public static interface IdValue {
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u0096\u0002J\b\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/qualifiedcactus/sqlObjectMapper/fromRs/IdMapping$SimpleIdValue;", "Lcom/qualifiedcactus/sqlObjectMapper/fromRs/IdMapping$IdValue;", "idValue", "", "(Ljava/lang/Object;)V", "equals", "", "other", "hashCode", "", "sqlObjectMapper"})
    public static final class SimpleIdValue
    implements IdValue {
        @NotNull
        private final Object idValue;

        public SimpleIdValue(@NotNull Object idValue) {
            Intrinsics.checkNotNullParameter((Object)idValue, (String)"idValue");
            this.idValue = idValue;
        }

        public int hashCode() {
            return this.idValue.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof SimpleIdValue && Intrinsics.areEqual((Object)((SimpleIdValue)other).idValue, (Object)this.idValue);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0004H\u0096\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\f"}, d2={"Lcom/qualifiedcactus/sqlObjectMapper/fromRs/IdMapping$CompositeIdValue;", "Lcom/qualifiedcactus/sqlObjectMapper/fromRs/IdMapping$IdValue;", "idValues", "", "", "([Ljava/lang/Object;)V", "hashCode", "", "[Ljava/lang/Object;", "equals", "", "other", "sqlObjectMapper"})
    public static final class CompositeIdValue
    implements IdValue {
        @NotNull
        private final Object[] idValues;
        private final int hashCode;

        public CompositeIdValue(@NotNull Object[] idValues) {
            Intrinsics.checkNotNullParameter((Object)idValues, (String)"idValues");
            this.idValues = idValues;
            int _hashCode = 1;
            int prime = 59;
            for (Object idValue : this.idValues) {
                if (idValue != null) {
                    _hashCode = _hashCode * prime + idValue.hashCode();
                    continue;
                }
                _hashCode *= prime;
            }
            this.hashCode = _hashCode;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof CompositeIdValue && Arrays.equals(((CompositeIdValue)other).idValues, this.idValues);
        }
    }
}

