/*
 * Decompiled with CFR 0.152.
 */
package com.qualifiedcactus.sqlObjectMapper.fromRs;

import com.qualifiedcactus.sqlObjectMapper.SqlObjectMapperException;
import com.qualifiedcactus.sqlObjectMapper.fromRs.IdMapping;
import com.qualifiedcactus.sqlObjectMapper.fromRs.RsClassMapping;
import com.qualifiedcactus.sqlObjectMapper.fromRs.RsTopClassMapping;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.full.KClasses;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0002\u001c\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u000b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001e\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001e"}, d2={"Lcom/qualifiedcactus/sqlObjectMapper/fromRs/RowParser;", "", "rs", "Ljava/sql/ResultSet;", "(Ljava/sql/ResultSet;)V", "getRs", "()Ljava/sql/ResultSet;", "rsMetaData", "Ljava/sql/ResultSetMetaData;", "getRsMetaData", "()Ljava/sql/ResultSetMetaData;", "handleNestedProperty", "nestedProperty", "Lcom/qualifiedcactus/sqlObjectMapper/fromRs/RsClassMapping$NestedProperty;", "parsedCollection", "", "Lcom/qualifiedcactus/sqlObjectMapper/fromRs/RowParser$ParsedCollection;", "handleSimpleProperty", "property", "Lcom/qualifiedcactus/sqlObjectMapper/fromRs/RsClassMapping$SimpleProperty;", "handleToManyProperty", "toManyProperty", "Lcom/qualifiedcactus/sqlObjectMapper/fromRs/RsClassMapping$ToManyProperty;", "parseWithNested", "Lcom/qualifiedcactus/sqlObjectMapper/fromRs/RowParser$ParseWithNestedResult;", "topClazzMapping", "Lcom/qualifiedcactus/sqlObjectMapper/fromRs/RsTopClassMapping;", "simpleParse", "ParseWithNestedResult", "ParsedCollection", "sqlObjectMapper"})
public final class RowParser {
    @NotNull
    private final ResultSet rs;
    @NotNull
    private final ResultSetMetaData rsMetaData;

    public RowParser(@NotNull ResultSet rs) {
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        this.rs = rs;
        ResultSetMetaData resultSetMetaData = this.rs.getMetaData();
        Intrinsics.checkNotNullExpressionValue((Object)resultSetMetaData, (String)"rs.metaData");
        this.rsMetaData = resultSetMetaData;
    }

    @NotNull
    public final ResultSet getRs() {
        return this.rs;
    }

    @NotNull
    public final ResultSetMetaData getRsMetaData() {
        return this.rsMetaData;
    }

    @NotNull
    public final Object simpleParse(@NotNull RsTopClassMapping topClazzMapping) {
        Intrinsics.checkNotNullParameter((Object)topClazzMapping, (String)"topClazzMapping");
        Object[] propertyValues = new Object[topClazzMapping.getRootMapping().getProperties().size()];
        int i = 1;
        int n = this.rsMetaData.getColumnCount();
        if (i <= n) {
            while (true) {
                if (topClazzMapping.getPropertyNameDict().get(this.rsMetaData.getColumnLabel(i)) != null) {
                    Pair<RsClassMapping.SimpleProperty, Integer> pair;
                    RsClassMapping.SimpleProperty simpleProperty = (RsClassMapping.SimpleProperty)pair.component1();
                    int propertyIndex = ((Number)pair.component2()).intValue();
                    propertyValues[propertyIndex] = simpleProperty.getValueConverter().convert(this.rs.getObject(i), simpleProperty.getType());
                }
                if (i == n) break;
                ++i;
            }
        }
        return topClazzMapping.getRootMapping().createInstance(propertyValues);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ParseWithNestedResult parseWithNested(@NotNull RsTopClassMapping topClazzMapping) {
        List list;
        Intrinsics.checkNotNullParameter((Object)topClazzMapping, (String)"topClazzMapping");
        if (topClazzMapping.getToManyList().isEmpty()) {
            List list2 = Collections.emptyList();
            list = list2;
            Intrinsics.checkNotNullExpressionValue(list2, (String)"{\n            Collections.emptyList()\n        }");
        } else {
            list = new ArrayList(topClazzMapping.getToManyList().size());
        }
        List parsedCollection = list;
        Object[] propertiesValues = new Object[topClazzMapping.getRootMapping().getProperties().size()];
        Iterable $this$forEachIndexed$iv = topClazzMapping.getRootMapping().getProperties();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            Object object;
            void property;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            RsClassMapping.ClassProperty classProperty = (RsClassMapping.ClassProperty)item$iv;
            int i = n;
            boolean bl = false;
            void var13_13 = property;
            if (var13_13 instanceof RsClassMapping.SimpleProperty) {
                object = this.handleSimpleProperty((RsClassMapping.SimpleProperty)property);
            } else if (var13_13 instanceof RsClassMapping.NestedProperty) {
                object = this.handleNestedProperty((RsClassMapping.NestedProperty)property, parsedCollection);
            } else if (var13_13 instanceof RsClassMapping.ToManyProperty) {
                object = this.handleToManyProperty((RsClassMapping.ToManyProperty)property, parsedCollection);
            } else {
                throw new RuntimeException("Unreachable");
            }
            propertiesValues[i] = object;
        }
        Object output = topClazzMapping.getRootMapping().createInstance(propertiesValues);
        return new ParseWithNestedResult(output, parsedCollection);
    }

    private final Object handleSimpleProperty(RsClassMapping.SimpleProperty property) {
        return property.getValueConverter().convert(this.rs.getObject(property.getName()), property.getType());
    }

    /*
     * WARNING - void declaration
     */
    private final Object handleNestedProperty(RsClassMapping.NestedProperty nestedProperty, List<ParsedCollection> parsedCollection) {
        RsClassMapping clazzMapping = nestedProperty.getClassMapping().getRootMapping();
        if (nestedProperty.getToOne()) {
            IdMapping idMapping2 = nestedProperty.getClassMapping().getIdMapping();
            if (idMapping2.getNoId()) {
                throw new SqlObjectMapperException(clazzMapping.getClazz() + " doesn't have id column(s)");
            }
            if (idMapping2.fromResultSet(this.rs) == null) {
                return null;
            }
        }
        Object[] propertiesValues = new Object[clazzMapping.getProperties().size()];
        Iterable $this$forEachIndexed$iv = clazzMapping.getProperties();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            Object object;
            void innerProperty;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            RsClassMapping.ClassProperty classProperty = (RsClassMapping.ClassProperty)item$iv;
            int i = n;
            boolean bl = false;
            void var14_14 = innerProperty;
            if (var14_14 instanceof RsClassMapping.SimpleProperty) {
                object = this.handleSimpleProperty((RsClassMapping.SimpleProperty)innerProperty);
            } else if (var14_14 instanceof RsClassMapping.NestedProperty) {
                object = this.handleNestedProperty((RsClassMapping.NestedProperty)innerProperty, parsedCollection);
            } else if (var14_14 instanceof RsClassMapping.ToManyProperty) {
                object = this.handleToManyProperty((RsClassMapping.ToManyProperty)innerProperty, parsedCollection);
            } else {
                throw new RuntimeException("Unreachable");
            }
            propertiesValues[i] = object;
        }
        return clazzMapping.createInstance(propertiesValues);
    }

    private final Object handleToManyProperty(RsClassMapping.ToManyProperty toManyProperty, List<ParsedCollection> parsedCollection) {
        Collection collection;
        if (KClasses.isSuperclassOf(toManyProperty.getCollectionType(), (KClass)Reflection.getOrCreateKotlinClass(List.class))) {
            collection = new ArrayList();
        } else if (KClasses.isSuperclassOf(toManyProperty.getCollectionType(), (KClass)Reflection.getOrCreateKotlinClass(Set.class))) {
            collection = new HashSet();
        } else {
            throw new SqlObjectMapperException(toManyProperty.getCollectionType() + " is not the supported collection type");
        }
        Collection collection2 = collection;
        parsedCollection.add(new ParsedCollection(toManyProperty, collection2));
        return collection2;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0005\u00a2\u0006\u0002\u0010\u0006R\u0019\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/qualifiedcactus/sqlObjectMapper/fromRs/RowParser$ParsedCollection;", "", "info", "Lcom/qualifiedcactus/sqlObjectMapper/fromRs/RsClassMapping$ToManyProperty;", "collection", "", "(Lcom/qualifiedcactus/sqlObjectMapper/fromRs/RsClassMapping$ToManyProperty;Ljava/util/Collection;)V", "getCollection", "()Ljava/util/Collection;", "getInfo", "()Lcom/qualifiedcactus/sqlObjectMapper/fromRs/RsClassMapping$ToManyProperty;", "sqlObjectMapper"})
    public static final class ParsedCollection {
        @NotNull
        private final RsClassMapping.ToManyProperty info;
        @NotNull
        private final Collection<Object> collection;

        public ParsedCollection(@NotNull RsClassMapping.ToManyProperty info, @NotNull Collection<Object> collection) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            Intrinsics.checkNotNullParameter(collection, (String)"collection");
            this.info = info;
            this.collection = collection;
        }

        @NotNull
        public final RsClassMapping.ToManyProperty getInfo() {
            return this.info;
        }

        @NotNull
        public final Collection<Object> getCollection() {
            return this.collection;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/qualifiedcactus/sqlObjectMapper/fromRs/RowParser$ParseWithNestedResult;", "", "value", "toManyCollectionList", "", "Lcom/qualifiedcactus/sqlObjectMapper/fromRs/RowParser$ParsedCollection;", "(Ljava/lang/Object;Ljava/util/List;)V", "getToManyCollectionList", "()Ljava/util/List;", "getValue", "()Ljava/lang/Object;", "sqlObjectMapper"})
    public static final class ParseWithNestedResult {
        @NotNull
        private final Object value;
        @NotNull
        private final List<ParsedCollection> toManyCollectionList;

        public ParseWithNestedResult(@NotNull Object value, @NotNull List<ParsedCollection> toManyCollectionList) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter(toManyCollectionList, (String)"toManyCollectionList");
            this.value = value;
            this.toManyCollectionList = toManyCollectionList;
        }

        @NotNull
        public final Object getValue() {
            return this.value;
        }

        @NotNull
        public final List<ParsedCollection> getToManyCollectionList() {
            return this.toManyCollectionList;
        }
    }
}

