/*
 * Decompiled with CFR 0.152.
 */
package com.qualifiedcactus.sqlObjectMapper.fromRs;

import com.qualifiedcactus.sqlObjectMapper.SqlObjectMapperException;
import com.qualifiedcactus.sqlObjectMapper.fromRs.RsValueExtractor;
import java.lang.annotation.Annotation;
import java.nio.ByteBuffer;
import java.sql.ResultSet;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u001b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0014\u0010\u0011\u001a\u0004\u0018\u00010\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/qualifiedcactus/sqlObjectMapper/fromRs/RsByteArrayToUuidExtractor;", "Lcom/qualifiedcactus/sqlObjectMapper/fromRs/RsValueExtractor;", "propertyType", "Lkotlin/reflect/KType;", "annotations", "", "", "(Lkotlin/reflect/KType;[Ljava/lang/annotation/Annotation;)V", "extractValueByIndex", "Ljava/util/UUID;", "rs", "Ljava/sql/ResultSet;", "columnIndex", "", "extractValueByName", "columnName", "", "processValue", "value", "", "sqlObjectMapper"})
public final class RsByteArrayToUuidExtractor
extends RsValueExtractor {
    public RsByteArrayToUuidExtractor(@NotNull KType propertyType, @NotNull Annotation[] annotations) {
        Intrinsics.checkNotNullParameter((Object)propertyType, (String)"propertyType");
        Intrinsics.checkNotNullParameter((Object)annotations, (String)"annotations");
        super(propertyType, annotations);
    }

    @Override
    @Nullable
    public UUID extractValueByName(@NotNull ResultSet rs, @NotNull String columnName) {
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        Intrinsics.checkNotNullParameter((Object)columnName, (String)"columnName");
        return this.processValue(rs.getBytes(columnName));
    }

    @Override
    @Nullable
    public UUID extractValueByIndex(@NotNull ResultSet rs, int columnIndex) {
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        return this.processValue(rs.getBytes(columnIndex));
    }

    private final UUID processValue(byte[] value) {
        if (value == null) {
            return null;
        }
        if (value.length != 16) {
            throw new SqlObjectMapperException("Invalid converter usage: byte array size (" + value.length + ") is not 16");
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(value);
        return new UUID(byteBuffer.getLong(), byteBuffer.getLong());
    }
}

