/*
 * Decompiled with CFR 0.152.
 */
package com.qualifiedcactus.sqlObjectMapper.fromRs.mapping;

import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J$\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u00060\tj\u0002`\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J$\u0010\r\u001a\u00020\u00072\n\u0010\b\u001a\u00060\tj\u0002`\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a8\u0006\u000e"}, d2={"Lcom/qualifiedcactus/sqlObjectMapper/fromRs/mapping/CamelCaseToUpperSnakeCaseConverter;", "", "()V", "convert", "", "input", "parseNumber", "", "out", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "indexRef", "Ljava/util/concurrent/atomic/AtomicInteger;", "parseWord", "sqlObjectMapper"})
public final class CamelCaseToUpperSnakeCaseConverter {
    @NotNull
    public static final CamelCaseToUpperSnakeCaseConverter INSTANCE = new CamelCaseToUpperSnakeCaseConverter();

    private CamelCaseToUpperSnakeCaseConverter() {
    }

    @NotNull
    public final String convert(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        StringBuilder out = new StringBuilder();
        AtomicInteger curIndex = new AtomicInteger(0);
        while (curIndex.get() < input.length()) {
            if (Character.isDigit(input.charAt(curIndex.get()))) {
                this.parseNumber(out, curIndex, input);
                continue;
            }
            this.parseWord(out, curIndex, input);
        }
        String string = out.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"out.toString()");
        return string;
    }

    private final void parseWord(StringBuilder out, AtomicInteger indexRef, String input) {
        while (indexRef.get() < input.length()) {
            out.append(Character.toUpperCase(input.charAt(indexRef.get())));
            if (indexRef.addAndGet(1) >= input.length() || !Character.isUpperCase(input.charAt(indexRef.get())) && !Character.isDigit(input.charAt(indexRef.get()))) continue;
            out.append('_');
            break;
        }
    }

    private final void parseNumber(StringBuilder out, AtomicInteger indexRef, String input) {
        while (indexRef.get() < input.length()) {
            out.append(Character.toLowerCase(input.charAt(indexRef.get())));
            if (indexRef.addAndGet(1) >= input.length() || Character.isDigit(input.charAt(indexRef.get()))) continue;
            out.append('_');
            break;
        }
    }
}

