/*
 * Decompiled with CFR 0.152.
 */
package com.qualifiedcactus.sqlObjectMapper.fromRs.resultSetProcessing;

import com.qualifiedcactus.sqlObjectMapper.MappingProvider;
import com.qualifiedcactus.sqlObjectMapper.SqlObjectMapperException;
import com.qualifiedcactus.sqlObjectMapper.fromRs.mapping.RsTotalClassMapping;
import com.qualifiedcactus.sqlObjectMapper.fromRs.resultSetProcessing.ResultSetProcessor;
import com.qualifiedcactus.sqlObjectMapper.fromRs.strategies.ParseRsForNoRelation;
import com.qualifiedcactus.sqlObjectMapper.fromRs.strategies.ParseRsForRecursiveRelation;
import com.qualifiedcactus.sqlObjectMapper.fromRs.strategies.ParseRsForToManyRelation;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001d\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0002\u0010\bB\u001d\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\u0002\u0010\nB\u0017\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u000fH\u0016J\u000f\u0010\u0013\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u0014J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018H\u0016J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aH\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/qualifiedcactus/sqlObjectMapper/fromRs/resultSetProcessing/MResultSet;", "T", "", "Lcom/qualifiedcactus/sqlObjectMapper/fromRs/resultSetProcessing/ResultSetProcessor;", "resultSet", "Ljava/sql/ResultSet;", "type", "Lkotlin/reflect/KClass;", "(Ljava/sql/ResultSet;Lkotlin/reflect/KClass;)V", "Ljava/lang/Class;", "(Ljava/sql/ResultSet;Ljava/lang/Class;)V", "mapping", "Lcom/qualifiedcactus/sqlObjectMapper/fromRs/mapping/RsTotalClassMapping;", "(Ljava/sql/ResultSet;Lcom/qualifiedcactus/sqlObjectMapper/fromRs/mapping/RsTotalClassMapping;)V", "addToCollection", "", "collection", "", "close", "firstOnly", "()Ljava/lang/Object;", "toList", "", "toSet", "", "toStream", "Ljava/util/stream/Stream;", "sqlObjectMapper"})
public final class MResultSet<T>
implements ResultSetProcessor<T> {
    @NotNull
    private final ResultSet resultSet;
    @NotNull
    private final RsTotalClassMapping mapping;

    public MResultSet(@NotNull ResultSet resultSet, @NotNull RsTotalClassMapping mapping) {
        Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
        Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
        this.resultSet = resultSet;
        this.mapping = mapping;
    }

    public MResultSet(@NotNull ResultSet resultSet, @NotNull KClass<T> type) {
        Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        this(resultSet, MappingProvider.INSTANCE.mapRsClass(type));
    }

    public MResultSet(@NotNull ResultSet resultSet, @NotNull Class<T> type) {
        Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        this(resultSet, MappingProvider.INSTANCE.mapRsClass(JvmClassMappingKt.getKotlinClass(type)));
    }

    private final void addToCollection(Collection<Object> collection) {
        switch (WhenMappings.$EnumSwitchMapping$0[this.mapping.getRelation().ordinal()]) {
            case 1: {
                ParseRsForNoRelation.INSTANCE.createRsStreamNoRelation(this.resultSet, this.mapping).forEach(arg_0 -> MResultSet.addToCollection$lambda$0(collection, arg_0));
                break;
            }
            case 2: {
                ParseRsForRecursiveRelation.INSTANCE.parseRsRecursiveRelation(this.resultSet, this.mapping, collection);
                break;
            }
            case 3: {
                ParseRsForToManyRelation.INSTANCE.parseRsToManyRelation(this.resultSet, this.mapping, collection);
            }
        }
    }

    @Override
    @NotNull
    public List<T> toList() {
        ArrayList out = new ArrayList();
        this.addToCollection(out);
        this.close();
        return out;
    }

    @Override
    @NotNull
    public Set<T> toSet() {
        HashSet out = new HashSet();
        this.addToCollection(out);
        this.close();
        return out;
    }

    @Override
    @NotNull
    public Stream<T> toStream() {
        if (this.mapping.getRelation() != RsTotalClassMapping.Relation.NoRelation) {
            throw new SqlObjectMapperException("Stream for DTO Class with to-many or recursive relation is not supported");
        }
        Stream<Object> stream = ParseRsForNoRelation.INSTANCE.createRsStreamNoRelation(this.resultSet, this.mapping);
        Intrinsics.checkNotNull(stream, (String)"null cannot be cast to non-null type java.util.stream.Stream<T of com.qualifiedcactus.sqlObjectMapper.fromRs.resultSetProcessing.MResultSet>");
        return stream;
    }

    @Override
    @Nullable
    public T firstOnly() {
        if (this.mapping.getRelation() != RsTotalClassMapping.Relation.NoRelation) {
            throw new SqlObjectMapperException("Fetching first row for DTO Class with to-many or recursive relation is not supported");
        }
        Object out = this.resultSet.next() ? ParseRsForNoRelation.INSTANCE.parseRowNoRelation(this.resultSet, this.mapping) : null;
        this.close();
        return (T)out;
    }

    @Override
    public void close() {
        this.resultSet.close();
    }

    private static final void addToCollection$lambda$0(Collection $collection, Object it) {
        Intrinsics.checkNotNullParameter((Object)$collection, (String)"$collection");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        $collection.add(it);
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RsTotalClassMapping.Relation.values().length];
            try {
                nArray[RsTotalClassMapping.Relation.NoRelation.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RsTotalClassMapping.Relation.RecursiveRelation.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RsTotalClassMapping.Relation.ToManyRelation.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

