/*
 * Decompiled with CFR 0.152.
 */
package com.qualifiedcactus.sqlObjectMapper.fromRs.strategies;

import com.qualifiedcactus.sqlObjectMapper.MissingColumnException;
import com.qualifiedcactus.sqlObjectMapper.SqlObjectMapperException;
import com.qualifiedcactus.sqlObjectMapper.fromRs.mapping.AddressDictionary;
import com.qualifiedcactus.sqlObjectMapper.fromRs.mapping.ClassProperty;
import com.qualifiedcactus.sqlObjectMapper.fromRs.mapping.RsLocalClassMapping;
import com.qualifiedcactus.sqlObjectMapper.fromRs.mapping.RsTotalClassMapping;
import com.qualifiedcactus.sqlObjectMapper.fromRs.strategies.IdValue;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001f\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u001bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JG\u0010\u0003\u001a\u0004\u0018\u00010\u00012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0016\u0010\n\u001a\u0012\u0012\u000e\u0012\f\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\f0\u000bH\u0002\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0013H\u0002J$\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00132\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00010\f\u00a8\u0006\u001c"}, d2={"Lcom/qualifiedcactus/sqlObjectMapper/fromRs/strategies/ParseRsForRecursiveRelation;", "", "()V", "createObject", "rawParamValues", "", "curLocal", "Lcom/qualifiedcactus/sqlObjectMapper/fromRs/mapping/RsLocalClassMapping;", "nullIfAllIsNull", "", "recursiveCollection", "Ljava/util/concurrent/atomic/AtomicReference;", "", "([Ljava/lang/Object;Lcom/qualifiedcactus/sqlObjectMapper/fromRs/mapping/RsLocalClassMapping;ZLjava/util/concurrent/atomic/AtomicReference;)Ljava/lang/Object;", "findMissingColumnAndRow", "", "rsMetaData", "Ljava/sql/ResultSetMetaData;", "totalMapping", "Lcom/qualifiedcactus/sqlObjectMapper/fromRs/mapping/RsTotalClassMapping;", "parseRow", "Lcom/qualifiedcactus/sqlObjectMapper/fromRs/strategies/ParseRsForRecursiveRelation$RowData;", "resultSet", "Ljava/sql/ResultSet;", "totalClassMapping", "parseRsRecursiveRelation", "resultCollection", "RowData", "sqlObjectMapper"})
public final class ParseRsForRecursiveRelation {
    @NotNull
    public static final ParseRsForRecursiveRelation INSTANCE = new ParseRsForRecursiveRelation();

    private ParseRsForRecursiveRelation() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void parseRsRecursiveRelation(@NotNull ResultSet resultSet, @NotNull RsTotalClassMapping totalClassMapping, @NotNull Collection<Object> resultCollection) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
        Intrinsics.checkNotNullParameter((Object)totalClassMapping, (String)"totalClassMapping");
        Intrinsics.checkNotNullParameter(resultCollection, (String)"resultCollection");
        AutoCloseable autoCloseable = resultSet;
        Throwable throwable = null;
        try {
            ResultSet rs = (ResultSet)autoCloseable;
            boolean bl = false;
            HashMap objectDict = new HashMap();
            while (rs.next()) {
                RowData rowData = INSTANCE.parseRow(resultSet, totalClassMapping);
                if (Intrinsics.areEqual((Object)rowData.getObjectId(), (Object)IdValue.NullIdValue.INSTANCE)) {
                    throw new SqlObjectMapperException("ID column(s) is null, which shouldn't be the case");
                }
                ((Map)objectDict).put(rowData.getObjectId(), rowData);
                if (!Intrinsics.areEqual((Object)rowData.getParentId(), (Object)IdValue.NullIdValue.INSTANCE)) continue;
                resultCollection.add(rowData.getObjectValue());
            }
            object = objectDict;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        HashMap objectDict = object;
        Map $this$forEach$iv = objectDict;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv.entrySet().iterator();
        while (object.hasNext()) {
            RowData parent;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = (Map.Entry)object.next();
            boolean bl = false;
            RowData rowData = (RowData)entry.getValue();
            if (Intrinsics.areEqual((Object)rowData.getParentId(), (Object)IdValue.NullIdValue.INSTANCE)) continue;
            if ((RowData)objectDict.get(rowData.getParentId()) == null) {
                throw new SqlObjectMapperException("Can't find parent object with the id value of " + rowData.getParentId());
            }
            Intrinsics.checkNotNullExpressionValue((Object)parent, (String)"objectDict[rowData.paren\u2026 of ${rowData.parentId}\")");
            parent.getRecursiveCollection().add(rowData.getObjectValue());
        }
    }

    private final RowData parseRow(ResultSet resultSet, RsTotalClassMapping totalClassMapping) {
        ResultSetMetaData rsMetaData = resultSet.getMetaData();
        Object[] paramValues = new Object[totalClassMapping.getRoot().getPropertiesCount()];
        Object[] objectIdValues = new Object[totalClassMapping.getIdProperties().size()];
        Object[] parentIdValues = new Object[totalClassMapping.getIdProperties().size()];
        AtomicReference<Collection<Object>> recursiveCollection = new AtomicReference<Collection<Object>>();
        int matchedColumnsCount = 0;
        int i = 1;
        int n = rsMetaData.getColumnCount();
        if (i <= n) {
            while (true) {
                String columnLabel = rsMetaData.getColumnLabel(i);
                if ((AddressDictionary.PropertyInstruction[])totalClassMapping.getAddressDict().get((Object)columnLabel) != null) {
                    AddressDictionary.PropertyInstruction[] instructions;
                    ++matchedColumnsCount;
                    Object[] curParamArray = null;
                    curParamArray = paramValues;
                    for (AddressDictionary.PropertyInstruction instruction : instructions) {
                        AddressDictionary.PropertyInstruction propertyInstruction = instruction;
                        if (propertyInstruction instanceof AddressDictionary.SimplePropertyInstruction) {
                            Object value;
                            curParamArray[((AddressDictionary.SimplePropertyInstruction)instruction).getProperty().getPropertyInfo().getIndex()] = value = ((AddressDictionary.SimplePropertyInstruction)instruction).getProperty().getExtractor().extractValueByIndex(resultSet, i);
                            if (!((AddressDictionary.SimplePropertyInstruction)instruction).getProperty().isId()) continue;
                            objectIdValues[((AddressDictionary.SimplePropertyInstruction)instruction).getProperty().getIdIndex()] = value;
                            continue;
                        }
                        if (propertyInstruction instanceof AddressDictionary.NestedPropertyInstruction) {
                            Object[] objectArray = (Object[])curParamArray[((AddressDictionary.NestedPropertyInstruction)instruction).getProperty().getPropertyInfo().getIndex()];
                            if (objectArray == null) {
                                Object[] array;
                                ParseRsForRecursiveRelation $this$parseRow_u24lambda_u242 = this;
                                boolean bl = false;
                                curParamArray[((AddressDictionary.NestedPropertyInstruction)instruction).getProperty().getPropertyInfo().getIndex()] = array = new Object[((AddressDictionary.NestedPropertyInstruction)instruction).getProperty().getLocalClassMapping().getPropertiesCount()];
                                objectArray = array;
                            }
                            Object[] nextArray = objectArray;
                            curParamArray = nextArray;
                            continue;
                        }
                        if (!(propertyInstruction instanceof AddressDictionary.RecursivePropertyInstruction)) continue;
                        parentIdValues[((AddressDictionary.RecursivePropertyInstruction)instruction).getParentIdIndex()] = totalClassMapping.getIdProperties().get(((AddressDictionary.RecursivePropertyInstruction)instruction).getParentIdIndex()).getExtractor().extractValueByIndex(resultSet, i);
                    }
                }
                if (i == n) break;
                ++i;
            }
        }
        if (matchedColumnsCount != totalClassMapping.getAddressDict().size()) {
            Intrinsics.checkNotNullExpressionValue((Object)rsMetaData, (String)"rsMetaData");
            this.findMissingColumnAndRow(rsMetaData, totalClassMapping);
        }
        IdValue idValue = IdValue.Companion.fromValues(Arrays.copyOf(objectIdValues, objectIdValues.length));
        Object object = this.createObject(paramValues, totalClassMapping.getRoot(), false, recursiveCollection);
        Intrinsics.checkNotNull((Object)object);
        Collection<Object> collection = recursiveCollection.get();
        if (collection == null) {
            throw new SqlObjectMapperException("Internal Error: Recursive collection not found in " + totalClassMapping.getRoot().getBaseClassInfo().getKClass());
        }
        return new RowData(idValue, object, collection, IdValue.Companion.fromValues(Arrays.copyOf(parentIdValues, parentIdValues.length)));
    }

    private final Object createObject(Object[] rawParamValues, RsLocalClassMapping curLocal, boolean nullIfAllIsNull, AtomicReference<Collection<Object>> recursiveCollection) {
        boolean isNull = false;
        isNull = nullIfAllIsNull;
        if (isNull) {
            for (ClassProperty.SimpleProperty simpleProperty : curLocal.getSimpleProperties()) {
                isNull = isNull && rawParamValues[simpleProperty.getPropertyInfo().getIndex()] == null;
            }
        }
        if (!((Collection)curLocal.getRecursiveProperties()).isEmpty()) {
            ClassProperty.RecursiveProperty property = (ClassProperty.RecursiveProperty)CollectionsKt.first(curLocal.getRecursiveProperties());
            Collection collection = (Collection)property.getCollectionSupplier().invoke();
            rawParamValues[property.getPropertyInfo().getIndex()] = collection;
            recursiveCollection.set(collection);
        }
        Iterable $this$forEach$iv = curLocal.getNestedProperties();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ClassProperty.NestedProperty nestedProperty = (ClassProperty.NestedProperty)element$iv;
            boolean bl = false;
            Object object = rawParamValues[nestedProperty.getPropertyInfo().getIndex()];
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
            Object nestedValue = INSTANCE.createObject((Object[])object, nestedProperty.getLocalClassMapping(), nestedProperty.getNullIfAllIsNull(), recursiveCollection);
            if (nullIfAllIsNull) {
                isNull = isNull && nestedValue == null;
            }
            rawParamValues[nestedProperty.getPropertyInfo().getIndex()] = nestedValue;
        }
        if (isNull && curLocal.getRecursiveProperties().isEmpty()) {
            return null;
        }
        return curLocal.getBaseClassInfo().getObjectSupplier().invoke((Object)rawParamValues);
    }

    private final void findMissingColumnAndRow(ResultSetMetaData rsMetaData, RsTotalClassMapping totalMapping) {
        ArrayList<String> missingColumnList = new ArrayList<String>();
        for (String requiredColumnLabel : totalMapping.getAddressDict().keySet()) {
            boolean found = false;
            int i = 1;
            int n = rsMetaData.getColumnCount();
            if (i <= n) {
                while (true) {
                    if (Intrinsics.areEqual((Object)requiredColumnLabel, (Object)rsMetaData.getColumnLabel(i))) {
                        found = true;
                        break;
                    }
                    if (i == n) break;
                    ++i;
                }
            }
            if (found) continue;
            missingColumnList.add(requiredColumnLabel);
        }
        throw new MissingColumnException(totalMapping.getRoot().getBaseClassInfo().getKClass(), (Collection<String>)missingColumnList);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0001H\u00c6\u0003J\u0011\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0006H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J9\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00012\u0010\b\u0002\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0019\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lcom/qualifiedcactus/sqlObjectMapper/fromRs/strategies/ParseRsForRecursiveRelation$RowData;", "", "objectId", "Lcom/qualifiedcactus/sqlObjectMapper/fromRs/strategies/IdValue;", "objectValue", "recursiveCollection", "", "parentId", "(Lcom/qualifiedcactus/sqlObjectMapper/fromRs/strategies/IdValue;Ljava/lang/Object;Ljava/util/Collection;Lcom/qualifiedcactus/sqlObjectMapper/fromRs/strategies/IdValue;)V", "getObjectId", "()Lcom/qualifiedcactus/sqlObjectMapper/fromRs/strategies/IdValue;", "getObjectValue", "()Ljava/lang/Object;", "getParentId", "getRecursiveCollection", "()Ljava/util/Collection;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "sqlObjectMapper"})
    private static final class RowData {
        @NotNull
        private final IdValue objectId;
        @NotNull
        private final Object objectValue;
        @NotNull
        private final Collection<Object> recursiveCollection;
        @NotNull
        private final IdValue parentId;

        public RowData(@NotNull IdValue objectId, @NotNull Object objectValue, @NotNull Collection<Object> recursiveCollection, @NotNull IdValue parentId) {
            Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
            Intrinsics.checkNotNullParameter((Object)objectValue, (String)"objectValue");
            Intrinsics.checkNotNullParameter(recursiveCollection, (String)"recursiveCollection");
            Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
            this.objectId = objectId;
            this.objectValue = objectValue;
            this.recursiveCollection = recursiveCollection;
            this.parentId = parentId;
        }

        @NotNull
        public final IdValue getObjectId() {
            return this.objectId;
        }

        @NotNull
        public final Object getObjectValue() {
            return this.objectValue;
        }

        @NotNull
        public final Collection<Object> getRecursiveCollection() {
            return this.recursiveCollection;
        }

        @NotNull
        public final IdValue getParentId() {
            return this.parentId;
        }

        @NotNull
        public final IdValue component1() {
            return this.objectId;
        }

        @NotNull
        public final Object component2() {
            return this.objectValue;
        }

        @NotNull
        public final Collection<Object> component3() {
            return this.recursiveCollection;
        }

        @NotNull
        public final IdValue component4() {
            return this.parentId;
        }

        @NotNull
        public final RowData copy(@NotNull IdValue objectId, @NotNull Object objectValue, @NotNull Collection<Object> recursiveCollection, @NotNull IdValue parentId) {
            Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
            Intrinsics.checkNotNullParameter((Object)objectValue, (String)"objectValue");
            Intrinsics.checkNotNullParameter(recursiveCollection, (String)"recursiveCollection");
            Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
            return new RowData(objectId, objectValue, recursiveCollection, parentId);
        }

        public static /* synthetic */ RowData copy$default(RowData rowData, IdValue idValue, Object object, Collection collection, IdValue idValue2, int n, Object object2) {
            if ((n & 1) != 0) {
                idValue = rowData.objectId;
            }
            if ((n & 2) != 0) {
                object = rowData.objectValue;
            }
            if ((n & 4) != 0) {
                collection = rowData.recursiveCollection;
            }
            if ((n & 8) != 0) {
                idValue2 = rowData.parentId;
            }
            return rowData.copy(idValue, object, collection, idValue2);
        }

        @NotNull
        public String toString() {
            return "RowData(objectId=" + this.objectId + ", objectValue=" + this.objectValue + ", recursiveCollection=" + this.recursiveCollection + ", parentId=" + this.parentId + ')';
        }

        public int hashCode() {
            int result = this.objectId.hashCode();
            result = result * 31 + this.objectValue.hashCode();
            result = result * 31 + ((Object)this.recursiveCollection).hashCode();
            result = result * 31 + this.parentId.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RowData)) {
                return false;
            }
            RowData rowData = (RowData)other;
            if (!Intrinsics.areEqual((Object)this.objectId, (Object)rowData.objectId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.objectValue, (Object)rowData.objectValue)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.recursiveCollection, rowData.recursiveCollection)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.parentId, (Object)rowData.parentId);
        }
    }
}

