/*
 * Decompiled with CFR 0.152.
 */
package com.qualifiedcactus.sqlObjectMapper.queryParsing;

import com.qualifiedcactus.sqlObjectMapper.SqlObjectMapperException;
import com.qualifiedcactus.sqlObjectMapper.queryParsing.NpParameter;
import java.io.PushbackReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 \f2\u00020\u0001:\u0002\f\rB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lcom/qualifiedcactus/sqlObjectMapper/queryParsing/NpQuery;", "", "translatedQuery", "", "parametersMap", "", "Lcom/qualifiedcactus/sqlObjectMapper/queryParsing/NpParameter;", "(Ljava/lang/String;Ljava/util/Map;)V", "getParametersMap", "()Ljava/util/Map;", "getTranslatedQuery", "()Ljava/lang/String;", "Companion", "NpQueryParser", "sqlObjectMapper"})
public final class NpQuery {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String translatedQuery;
    @NotNull
    private final Map<String, NpParameter> parametersMap;

    public NpQuery(@NotNull String translatedQuery, @NotNull Map<String, ? extends NpParameter> parametersMap) {
        Intrinsics.checkNotNullParameter((Object)translatedQuery, (String)"translatedQuery");
        Intrinsics.checkNotNullParameter(parametersMap, (String)"parametersMap");
        this.translatedQuery = translatedQuery;
        this.parametersMap = parametersMap;
    }

    @NotNull
    public final String getTranslatedQuery() {
        return this.translatedQuery;
    }

    @NotNull
    public final Map<String, NpParameter> getParametersMap() {
        return this.parametersMap;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/qualifiedcactus/sqlObjectMapper/queryParsing/NpQuery$Companion;", "", "()V", "parseNpSql", "Lcom/qualifiedcactus/sqlObjectMapper/queryParsing/NpQuery;", "npSql", "", "sqlObjectMapper"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NpQuery parseNpSql(@NotNull String npSql) {
            Intrinsics.checkNotNullParameter((Object)npSql, (String)"npSql");
            return new NpQueryParser(npSql).parseToNpSql();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u001bH\u0002J\b\u0010\u001d\u001a\u00020\u0003H\u0002J\b\u0010\u001e\u001a\u00020\u001bH\u0002J\u000f\u0010\u001f\u001a\u0004\u0018\u00010\u0006H\u0002\u00a2\u0006\u0002\u0010 J\u0006\u0010!\u001a\u00020\"R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR-\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r0\fj\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r`\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0015\u0010\u0015\u001a\u00060\u0016j\u0002`\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006#"}, d2={"Lcom/qualifiedcactus/sqlObjectMapper/queryParsing/NpQuery$NpQueryParser;", "", "npSql", "", "(Ljava/lang/String;)V", "curParamPosition", "", "getCurParamPosition", "()I", "setCurParamPosition", "(I)V", "parametersMap", "Ljava/util/HashMap;", "Lcom/qualifiedcactus/sqlObjectMapper/queryParsing/NpParameter;", "Lkotlin/collections/HashMap;", "getParametersMap", "()Ljava/util/HashMap;", "reader", "Ljava/io/PushbackReader;", "getReader", "()Ljava/io/PushbackReader;", "translatedQueryBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getTranslatedQueryBuilder", "()Ljava/lang/StringBuilder;", "parse", "", "parseParam", "parseParamName", "parseQuestionMark", "parseSquareBracketOfParam", "()Ljava/lang/Integer;", "parseToNpSql", "Lcom/qualifiedcactus/sqlObjectMapper/queryParsing/NpQuery;", "sqlObjectMapper"})
    private static final class NpQueryParser {
        @NotNull
        private final StringBuilder translatedQueryBuilder;
        private int curParamPosition;
        @NotNull
        private final PushbackReader reader;
        @NotNull
        private final HashMap<String, NpParameter> parametersMap;

        public NpQueryParser(@NotNull String npSql) {
            Intrinsics.checkNotNullParameter((Object)npSql, (String)"npSql");
            this.translatedQueryBuilder = new StringBuilder(npSql.length());
            this.reader = new PushbackReader(new StringReader(npSql));
            this.parametersMap = new HashMap();
        }

        @NotNull
        public final StringBuilder getTranslatedQueryBuilder() {
            return this.translatedQueryBuilder;
        }

        public final int getCurParamPosition() {
            return this.curParamPosition;
        }

        public final void setCurParamPosition(int n) {
            this.curParamPosition = n;
        }

        @NotNull
        public final PushbackReader getReader() {
            return this.reader;
        }

        @NotNull
        public final HashMap<String, NpParameter> getParametersMap() {
            return this.parametersMap;
        }

        @NotNull
        public final NpQuery parseToNpSql() {
            this.parse();
            String string = this.translatedQueryBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"translatedQueryBuilder.toString()");
            return new NpQuery(string, (Map<String, ? extends NpParameter>)this.parametersMap);
        }

        private final void parse() {
            int curChar;
            block4: while ((curChar = this.reader.read()) != -1) {
                switch (curChar) {
                    case 63: {
                        this.parseQuestionMark();
                        continue block4;
                    }
                    case 58: {
                        this.parseParam();
                        continue block4;
                    }
                }
                this.translatedQueryBuilder.appendCodePoint(curChar);
            }
        }

        private final void parseQuestionMark() {
            this.translatedQueryBuilder.append('?');
            int n = this.curParamPosition;
            this.curParamPosition = n + 1;
        }

        /*
         * WARNING - void declaration
         */
        private final void parseParam() {
            String string = this.parseParamName().toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            String paramName = string;
            Integer expandedParamLength = this.parseSquareBracketOfParam();
            NpParameter paramInfo = this.parametersMap.get(paramName);
            if (paramInfo == null) {
                if (expandedParamLength != null) {
                    void $this$parseParam_u24lambda_u240;
                    ArrayList arrayList;
                    int n = -1;
                    if (expandedParamLength == n) {
                        throw new SqlObjectMapperException("Empty length specified for expanded parameter " + paramName);
                    }
                    int startPosition = this.curParamPosition + 1;
                    int endPosition = startPosition + expandedParamLength - 1;
                    ArrayList arrayList2 = arrayList = new ArrayList();
                    int n2 = expandedParamLength;
                    boolean bl = false;
                    $this$parseParam_u24lambda_u240.add(TuplesKt.to((Object)startPosition, (Object)endPosition));
                    Unit unit = Unit.INSTANCE;
                    List list = arrayList;
                    int n3 = n2;
                    paramInfo = new NpParameter.ExpandedParameter(n3, list);
                    this.curParamPosition = endPosition;
                } else {
                    ArrayList<Integer> arrayList;
                    ArrayList<Integer> $this$parseParam_u24lambda_u241 = arrayList = new ArrayList<Integer>();
                    boolean bl = false;
                    ++this.curParamPosition;
                    $this$parseParam_u24lambda_u241.add(this.curParamPosition);
                    List list = arrayList;
                    paramInfo = new NpParameter.SimpleParameter(list);
                }
                ((Map)this.parametersMap).put(paramName, paramInfo);
            } else {
                NpParameter npParameter = paramInfo;
                if (npParameter instanceof NpParameter.SimpleParameter) {
                    if (expandedParamLength != null) {
                        throw new SqlObjectMapperException("Param " + paramName + " is not previously specified as an expanded parameter, but is specified as expanded parameter on second occurrence");
                    }
                    ++this.curParamPosition;
                    ((NpParameter.SimpleParameter)paramInfo).getPositionList().add(this.curParamPosition);
                } else if (npParameter instanceof NpParameter.ExpandedParameter) {
                    int startPosition = this.curParamPosition + 1;
                    int endPosition = startPosition + ((NpParameter.ExpandedParameter)paramInfo).getLength() - 1;
                    ((NpParameter.ExpandedParameter)paramInfo).getPositionRangeList().add((Pair<Integer, Integer>)TuplesKt.to((Object)startPosition, (Object)endPosition));
                    this.curParamPosition = endPosition;
                }
            }
            NpParameter npParameter = paramInfo;
            if (npParameter instanceof NpParameter.SimpleParameter) {
                this.translatedQueryBuilder.append('?');
            } else if (npParameter instanceof NpParameter.ExpandedParameter) {
                this.translatedQueryBuilder.append('(');
                int n = ((NpParameter.ExpandedParameter)paramInfo).getLength() - 1;
                for (int i = 0; i < n; ++i) {
                    this.translatedQueryBuilder.append("?,");
                }
                this.translatedQueryBuilder.append("?)");
            }
        }

        private final String parseParamName() {
            StringBuilder paramNameBuilder;
            block3: {
                int curChar;
                paramNameBuilder = new StringBuilder();
                int firstChar = this.reader.read();
                if (firstChar == -1) {
                    throw new SqlObjectMapperException("Unexpected end of sql string when parsing parameter name");
                }
                if (!Character.isJavaIdentifierStart(firstChar)) {
                    throw new SqlObjectMapperException("Invalid param name starter: " + Character.toChars(firstChar)[0]);
                }
                paramNameBuilder.appendCodePoint(firstChar);
                while (true) {
                    curChar = this.reader.read();
                    if (curChar == -1) break block3;
                    if (!Character.isJavaIdentifierPart(curChar)) break;
                    paramNameBuilder.appendCodePoint(curChar);
                }
                this.reader.unread(curChar);
            }
            String string = paramNameBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"paramNameBuilder.toString()");
            return string;
        }

        private final Integer parseSquareBracketOfParam() {
            int startChar = this.reader.read();
            if (startChar == -1) {
                return null;
            }
            if (startChar != 91) {
                this.reader.unread(startChar);
                return null;
            }
            StringBuilder numberStringBuilder = new StringBuilder();
            block4: while (true) {
                int curChar = this.reader.read();
                switch (curChar) {
                    case -1: {
                        throw new SqlObjectMapperException("Dangling '[' when parsing named-parameter sql");
                    }
                    case 93: {
                        break block4;
                    }
                    default: {
                        numberStringBuilder.appendCodePoint(curChar);
                        continue block4;
                    }
                }
                break;
            }
            if (((CharSequence)numberStringBuilder).length() == 0) {
                return -1;
            }
            String string = numberStringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"numberStringBuilder.toString()");
            int parsedNumber = Integer.parseInt(string);
            if (parsedNumber < 1) {
                throw new SqlObjectMapperException("The length of expanded parameter is 0 or negative (" + parsedNumber + ')');
            }
            return parsedNumber;
        }
    }
}

