/*
 * Decompiled with CFR 0.152.
 */
package com.raylabz.javahttp;

import com.raylabz.javahttp.HTTPResponse;
import com.raylabz.javahttp.MimeType;
import com.raylabz.javahttp.QueryStringMaker;
import com.raylabz.javahttp.RequestMethod;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class HTTPRequest {
    private static final int DEFAULT_CONNECT_TIMEOUT = 30000;
    private static final int DEFAULT_READ_TIMEOUT = 30000;
    private String url;
    private final HashMap<String, String> params;
    private final HashMap<String, String> requestProperties;
    private final RequestMethod requestMethod;
    private int connectTimeout;
    private int readTimeout;
    private String mimeType;

    private HTTPRequest(String url, RequestMethod requestMethod, HashMap<String, String> params, HashMap<String, String> requestProperties, int connectTimeout, int readTimeout, String mimeType) {
        this.url = url;
        this.requestMethod = requestMethod;
        this.params = params;
        this.requestProperties = requestProperties;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.mimeType = mimeType;
    }

    public String getUrl() {
        return this.url;
    }

    public HashMap<String, String> getParams() {
        return this.params;
    }

    public RequestMethod getRequestMethod() {
        return this.requestMethod;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public HTTPResponse call() {
        try {
            if (this.requestMethod == RequestMethod.GET) {
                this.url = this.url + "?" + QueryStringMaker.makeQueryString(this.params);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        try {
            String inputLine;
            int statusCode;
            URL obj = new URL(this.url);
            HttpURLConnection con = (HttpURLConnection)obj.openConnection();
            con.setConnectTimeout(this.connectTimeout);
            con.setReadTimeout(this.readTimeout);
            con.setDoOutput(true);
            con.setRequestMethod(this.requestMethod.toString());
            for (Map.Entry<String, String> entry : this.requestProperties.entrySet()) {
                con.setRequestProperty(entry.getKey(), entry.getValue());
            }
            if (this.requestMethod == RequestMethod.POST) {
                DataOutputStream out = new DataOutputStream(con.getOutputStream());
                out.writeBytes(QueryStringMaker.makeQueryString(this.params));
                out.flush();
                out.close();
            }
            InputStreamReader streamReader = (statusCode = con.getResponseCode()) > 299 ? new InputStreamReader(con.getErrorStream()) : new InputStreamReader(con.getInputStream());
            BufferedReader in = new BufferedReader(streamReader);
            StringBuilder content = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                content.append(inputLine);
            }
            in.close();
            return new HTTPResponse(statusCode, content.toString(), con.getHeaderFields());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Builder {
        private String url;
        private HashMap<String, String> params = new HashMap();
        private HashMap<String, String> requestProperties = new HashMap();
        private RequestMethod requestMethod;
        private int connectTimeout = 30000;
        private int readTimeout = 30000;
        private String mimeType = MimeType.CONTENT_TYPE_TEXT.getText();

        public Builder(String url, RequestMethod requestMethod) {
            this.url = url;
            this.requestMethod = requestMethod;
        }

        public Builder addParam(String paramName, String paramValue) {
            this.params.put(paramName, paramValue);
            return this;
        }

        public Builder addParam(String paramName, int paramValue) {
            this.params.put(paramName, String.valueOf(paramValue));
            return this;
        }

        public Builder addParam(String paramName, double paramValue) {
            this.params.put(paramName, String.valueOf(paramValue));
            return this;
        }

        public Builder addParam(String paramName, float paramValue) {
            this.params.put(paramName, String.valueOf(paramValue));
            return this;
        }

        public Builder addParam(String paramName, boolean paramValue) {
            this.params.put(paramName, String.valueOf(paramValue));
            return this;
        }

        public Builder addParam(String paramName, char paramValue) {
            this.params.put(paramName, String.valueOf(paramValue));
            return this;
        }

        public Builder addParam(String paramName, short paramValue) {
            this.params.put(paramName, String.valueOf(paramValue));
            return this;
        }

        public Builder addParam(String paramName, long paramValue) {
            this.params.put(paramName, String.valueOf(paramValue));
            return this;
        }

        public Builder setRequestProperty(String propertyKey, String propertyValue) {
            this.requestProperties.put(propertyKey, propertyValue);
            return this;
        }

        public Builder setConnectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder setReadTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder setMimeType(MimeType mimeType) {
            this.mimeType = mimeType.getText();
            this.requestProperties.put("Content-Type", mimeType.getText());
            return this;
        }

        public Builder setCustomMimeType(String customMimeType) {
            this.mimeType = customMimeType;
            this.requestProperties.put("Content-Type", customMimeType);
            return this;
        }

        public HTTPRequest build() {
            return new HTTPRequest(this.url, this.requestMethod, this.params, this.requestProperties, this.connectTimeout, this.readTimeout, this.mimeType);
        }
    }
}

