/*
 * Decompiled with CFR 0.152.
 */
package com.rm5248.serial;

import com.rm5248.serial.BufferedSerialInputStream;
import com.rm5248.serial.NoSuchPortException;
import com.rm5248.serial.NotASerialPortException;
import com.rm5248.serial.SerialChangeListener;
import com.rm5248.serial.SerialInputStream;
import com.rm5248.serial.SerialLineState;
import com.rm5248.serial.SerialOutputStream;
import com.rm5248.serial.SerialPortBuilder;
import com.rm5248.serial.SimpleSerialInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SerialPort
implements AutoCloseable {
    private static final Logger logger = Logger.getLogger(SerialPort.class.getName());
    private static final Logger native_logger = Logger.getLogger(SerialPort.class.getName() + ".native");
    public static final int NO_CONTROL_LINE_CHANGE = 0;
    public static final int CONTROL_LINE_DTR_CHANGE = 1;
    public static final int CONTROL_LINE_RTS_CHANGE = 2;
    public static final int CONTROL_LINE_CD_CHANGE = 3;
    public static final int CONTROL_LINE_CTS_CHANGE = 4;
    public static final int CONTROL_LINE_DSR_CHANGE = 5;
    public static final int CONTROL_LINE_RI_CHANGE = 6;
    public static final int ALL_CONTROL_LINES = 7;
    private int handle;
    private boolean closed;
    private String portName;
    private volatile SerialLineState state;
    private SimpleSerialInputStream simpleSerialInputStream;
    private BufferedSerialInputStream bis;
    private SerialOutputStream outputStream;
    private SerialStateListener serialListen;
    private Object serialListenSync;
    private int controlLineFlags;
    private boolean throwIOExceptionOnInterrupt;

    private static void loadNativeLibrary() {
        String nativeLibraryPath = System.getProperty("com.rm5248.javaserial.lib.path");
        String nativeLibraryName = System.getProperty("com.rm5248.javaserial.lib.name");
        if (nativeLibraryName == null) {
            nativeLibraryName = System.mapLibraryName("javaserial");
            if (nativeLibraryName.endsWith("dylib")) {
                nativeLibraryName = nativeLibraryName.replace("dylib", "jnilib");
            }
            logger.log(Level.FINE, "No native library name provided, using default of {0}", nativeLibraryName);
        }
        if (nativeLibraryPath != null) {
            logger.log(Level.FINE, "Native library path of {0} provided", nativeLibraryPath);
            File libToLoad = new File(nativeLibraryPath, nativeLibraryName);
            logger.log(Level.FINE, "Loading library {0}", libToLoad.getAbsolutePath());
            System.load(libToLoad.getAbsolutePath());
            return;
        }
        try {
            String osName = System.getProperty("os.name");
            osName = osName.contains("Windows") ? "Windows" : (osName.contains("Mac") || osName.contains("Darwin") ? "Mac" : (osName.contains("Linux") ? "Linux" : osName.replaceAll("\\W", "")));
            String arch = System.getProperty("os.arch");
            arch.replaceAll("\\W", "");
            if (arch.equals("x86_64")) {
                arch = "amd64";
            }
            Path tempFolder = Files.createTempDirectory("javaserial", new FileAttribute[0]);
            tempFolder.toFile().deleteOnExit();
            logger.log(Level.FINER, "Created temp folder of {0}", tempFolder);
            File extractedLib = new File(tempFolder.toFile(), nativeLibraryName);
            String fileToExtract = "/" + osName + "/" + arch + "/" + nativeLibraryName;
            logger.log(Level.FINER, "About to extract {0} from JAR", fileToExtract);
            InputStream library = SerialPort.class.getResourceAsStream(fileToExtract);
            Files.copy(library, extractedLib.toPath(), new CopyOption[0]);
            extractedLib.deleteOnExit();
            System.load(extractedLib.getAbsolutePath());
        }
        catch (IOException e) {
            throw new UnsatisfiedLinkError("Unable to create temp directory or extract: " + e.getMessage());
        }
    }

    public SerialPort(SerialPortBuilder builder) throws NoSuchPortException, NotASerialPortException, IOException {
        this.doOpenSerialPort(builder.portName, builder.baudRate, builder.dataBits, builder.stopBits, builder.parity, builder.flowControl, builder.controlFlags);
    }

    public SerialPort(String portName) throws NoSuchPortException, NotASerialPortException, IOException {
        this(portName, 7);
    }

    public SerialPort(String portName, int controlLineFlags) throws NoSuchPortException, NotASerialPortException, IOException {
        this(portName, BaudRate.B9600, controlLineFlags);
    }

    public SerialPort(String portName, boolean keepSettings) throws NoSuchPortException, NotASerialPortException, IOException {
        this(portName, keepSettings, 7);
    }

    public SerialPort(String portName, boolean keepSettings, int controlFlags) throws NoSuchPortException, NotASerialPortException, IOException {
        if (portName == null) {
            throw new IllegalArgumentException("portName must not be null");
        }
        if (keepSettings) {
            this.handle = -1;
            this.handle = this.openPort(portName);
            this.portName = portName;
            if (this.controlLineFlags == 0) {
                logger.log(Level.FINE, "Creating a new SimpleSerialInputStream - not monitoring for control line change");
                this.simpleSerialInputStream = new SimpleSerialInputStream(this.handle);
            } else {
                logger.log(Level.FINE, "Creating a new BufferedSerialInputStream - monitoring for control line change");
                SerialInputStream sis = new SerialInputStream(this.handle);
                this.bis = new BufferedSerialInputStream(sis, this);
            }
            this.outputStream = new SerialOutputStream(this.handle);
            this.closed = false;
            this.controlLineFlags = controlFlags;
            SerialLineState s = new SerialLineState();
            int state = this.getSerialLineStateInternalNonblocking();
            if ((state & 1) > 0) {
                s.carrierDetect = true;
            }
            if ((state & 2) > 0) {
                s.clearToSend = true;
            }
            if ((state & 4) > 0) {
                s.dataSetReady = true;
            }
            if ((state & 8) > 0) {
                s.dataTerminalReady = true;
            }
            if ((state & 0x10) > 0) {
                s.requestToSend = true;
            }
            if ((state & 0x20) > 0) {
                s.ringIndicator = true;
            }
            this.state = s;
            if (this.controlLineFlags != 0) {
                this.serialListenSync = new Object();
                new Thread((Runnable)this.bis, "BufferedSerialReader-" + portName).start();
            }
        } else {
            this.doOpenSerialPort(portName, BaudRate.B9600, DataBits.DATABITS_8, StopBits.STOPBITS_1, Parity.NONE, FlowControl.NONE, controlFlags);
        }
    }

    public SerialPort(String portName, BaudRate rate) throws NoSuchPortException, NotASerialPortException, IOException {
        this(portName, rate, 7);
    }

    public SerialPort(String portName, BaudRate rate, int controlLines) throws NoSuchPortException, NotASerialPortException, IOException {
        this(portName, rate, DataBits.DATABITS_8, controlLines);
    }

    public SerialPort(String portName, BaudRate rate, DataBits data) throws NoSuchPortException, NotASerialPortException, IOException {
        this(portName, rate, data, StopBits.STOPBITS_1, 7);
    }

    public SerialPort(String portName, BaudRate rate, DataBits data, int controlLineFlags) throws NoSuchPortException, NotASerialPortException, IOException {
        this.doOpenSerialPort(portName, rate, data, StopBits.STOPBITS_1, Parity.NONE, FlowControl.NONE, controlLineFlags);
    }

    public SerialPort(String portName, BaudRate rate, DataBits data, StopBits stop) throws NoSuchPortException, NotASerialPortException, IOException {
        this.doOpenSerialPort(portName, rate, data, stop, Parity.NONE, FlowControl.NONE, 7);
    }

    public SerialPort(String portName, BaudRate rate, DataBits data, StopBits stop, int controlFlags) throws NoSuchPortException, NotASerialPortException, IOException {
        this.doOpenSerialPort(portName, rate, data, stop, Parity.NONE, FlowControl.NONE, controlFlags);
    }

    public SerialPort(String portName, BaudRate rate, DataBits data, StopBits stop, Parity parity) throws NoSuchPortException, NotASerialPortException, IOException {
        this.doOpenSerialPort(portName, rate, data, stop, parity, FlowControl.NONE, 7);
    }

    public SerialPort(String portName, BaudRate rate, DataBits data, StopBits stop, Parity parity, int controlLineFlags) throws NoSuchPortException, NotASerialPortException, IOException {
        this(portName, rate, data, stop, parity, FlowControl.NONE, controlLineFlags);
    }

    public SerialPort(String portName, BaudRate rate, DataBits data, StopBits stop, Parity parity, FlowControl flow) throws NoSuchPortException, NotASerialPortException, IOException {
        this(portName, rate, data, stop, parity, flow, 7);
    }

    public SerialPort(String portName, BaudRate rate, DataBits data, StopBits stop, Parity parity, FlowControl flow, int controlFlags) throws NoSuchPortException, NotASerialPortException, IOException {
        this.doOpenSerialPort(portName, rate, data, stop, parity, flow, controlFlags);
    }

    private void doOpenSerialPort(String portName, BaudRate rate, DataBits data, StopBits stop, Parity parity, FlowControl flow, int controlFlags) throws NoSuchPortException, NotASerialPortException, IOException {
        this.handle = -1;
        this.throwIOExceptionOnInterrupt = false;
        if (portName == null) {
            throw new IllegalArgumentException("portName must not be null");
        }
        if (rate == null) {
            throw new IllegalArgumentException("rate must not be null");
        }
        if (data == null) {
            throw new IllegalArgumentException("data must not be null");
        }
        if (stop == null) {
            throw new IllegalArgumentException("stop must not be null");
        }
        if (parity == null) {
            throw new IllegalArgumentException("parity must not be null");
        }
        if (flow == null) {
            throw new IllegalArgumentException("flow must not be null");
        }
        logger.log(Level.INFO, "Opening up serial port {0} with the following settings: speed:{1} data:{2} stop:{3} parity:{4} flow:{5}", new Object[]{portName, rate, data, stop, parity, flow});
        this.portName = portName;
        this.closed = false;
        this.controlLineFlags = controlFlags;
        this.handle = this.openPort(portName, rate.getBaudRate(), data.getDataBits(), stop.getStopBits(), parity.getParity(), flow.getFlowControl());
        if (this.controlLineFlags == 0) {
            logger.log(Level.FINE, "Creating a new SimpleSerialInputStream - not monitoring for control line change");
            this.simpleSerialInputStream = new SimpleSerialInputStream(this.handle);
        } else {
            logger.log(Level.FINE, "Creating a new BufferedSerialInputStream - monitoring for control line change");
            SerialInputStream sis = new SerialInputStream(this.handle);
            this.bis = new BufferedSerialInputStream(sis, this);
        }
        this.outputStream = new SerialOutputStream(this.handle);
        SerialLineState s = new SerialLineState();
        int state = this.getSerialLineStateInternalNonblocking();
        if ((state & 1) > 0) {
            s.carrierDetect = true;
        }
        if ((state & 2) > 0) {
            s.clearToSend = true;
        }
        if ((state & 4) > 0) {
            s.dataSetReady = true;
        }
        if ((state & 8) > 0) {
            s.dataTerminalReady = true;
        }
        if ((state & 0x10) > 0) {
            s.requestToSend = true;
        }
        if ((state & 0x20) > 0) {
            s.ringIndicator = true;
        }
        this.state = s;
        if (this.controlLineFlags != 0) {
            this.serialListenSync = new Object();
            new Thread((Runnable)this.bis, "BufferedSerialReader-" + portName).start();
        }
    }

    public void setBaudRate(BaudRate rate) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Cannot set the BaudRate once the port has been closed.");
        }
        if (rate == null) {
            throw new IllegalArgumentException("rate must not be null");
        }
        this.setBaudRate(rate.getBaudRate());
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void finalize() {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.doClose();
        if (this.serialListen != null) {
            this.serialListen.doStop();
        }
        if (this.serialListenSync != null) {
            Object object = this.serialListenSync;
            synchronized (object) {
                this.serialListenSync.notify();
            }
        }
    }

    public InputStream getInputStream() {
        if (this.isClosed()) {
            throw new IllegalStateException("Cannot get the input stream once the port has been closed.");
        }
        if (this.bis != null) {
            return this.bis;
        }
        if (this.simpleSerialInputStream != null) {
            return this.simpleSerialInputStream;
        }
        logger.log(Level.SEVERE, "Tried to get input stream, but both BufferedSerialInputStream and SimpleSerialInputStream null");
        return null;
    }

    public void setInterruptCausesIOException(boolean interruptCausesIOException) {
        this.throwIOExceptionOnInterrupt = interruptCausesIOException;
        if (this.bis != null) {
            this.bis.setInterruptCausesIOException(interruptCausesIOException);
        } else if (this.simpleSerialInputStream != null) {
            // empty if block
        }
    }

    public OutputStream getOutputStream() {
        if (this.isClosed()) {
            throw new IllegalStateException("Cannot get the output stream once the port has been closed.");
        }
        return this.outputStream;
    }

    public void setStopBits(StopBits stop) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Cannot set the StopBits once the port has been closed.");
        }
        if (stop == null) {
            throw new IllegalArgumentException("stop must not be null");
        }
        this.setStopBits(stop.getStopBits());
    }

    public void setDataSize(DataBits data) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Cannot set the DataBits once the port has been closed.");
        }
        if (data == null) {
            throw new IllegalArgumentException("data must not be null");
        }
        this.setCharSize(data.getDataBits());
    }

    public void setParity(Parity parity) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Cannot set the parity once the port has been closed.");
        }
        if (parity == null) {
            throw new IllegalArgumentException("parity must not be null");
        }
        this.setParity(parity.getParity());
    }

    public SerialLineState getSerialLineState() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Cannot get the serial line state once the port has been closed.");
        }
        int gotState = this.getSerialLineStateInternalNonblocking();
        SerialLineState s = new SerialLineState();
        if ((gotState & 1) > 0) {
            s.carrierDetect = true;
        }
        if ((gotState & 2) > 0) {
            s.clearToSend = true;
        }
        if ((gotState & 4) > 0) {
            s.dataSetReady = true;
        }
        if ((gotState & 8) > 0) {
            s.dataTerminalReady = true;
        }
        if ((gotState & 0x10) > 0) {
            s.requestToSend = true;
        }
        if ((gotState & 0x20) > 0) {
            s.ringIndicator = true;
        }
        return s;
    }

    public void setSerialLineState(SerialLineState state) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Cannot set the serial line state once the port has been closed.");
        }
        this.setSerialLineStateInternal(state);
    }

    public BaudRate getBaudRate() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Cannot get the baud rate once the port has been closed.");
        }
        int baudRate = this.getBaudRateInternal();
        for (BaudRate b : BaudRate.values()) {
            if (b.getBaudRate() != baudRate) continue;
            return b;
        }
        return BaudRate.B0;
    }

    public DataBits getDataBits() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Cannot get the data bits once the port has been closed.");
        }
        int dataBits = this.getCharSizeInternal();
        for (DataBits d : DataBits.values()) {
            if (dataBits != d.getDataBits()) continue;
            return d;
        }
        return DataBits.DATABITS_8;
    }

    public StopBits getStopBits() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Cannot get stop bits once the port has been closed.");
        }
        int stopBits = this.getStopBitsInternal();
        for (StopBits sb : StopBits.values()) {
            if (sb.getStopBits() != stopBits) continue;
            return sb;
        }
        return StopBits.STOPBITS_1;
    }

    public Parity getParity() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Cannot get the parity once the port has been closed.");
        }
        int parity = this.getParityInternal();
        for (Parity par : Parity.values()) {
            if (par.getParity() != parity) continue;
            return par;
        }
        return Parity.NONE;
    }

    public FlowControl getFlowControl() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Cannot get the flow once the port has been closed.");
        }
        int flowControl = this.getFlowControlInternal();
        for (FlowControl control : FlowControl.values()) {
            if (control.getFlowControl() != flowControl) continue;
            return control;
        }
        return FlowControl.NONE;
    }

    public void setFlowControl(FlowControl flow) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Cannot set flow once the port has been closed.");
        }
        this.setFlowControl(flow.getFlowControl());
    }

    public void setSerialChangeListener(SerialChangeListener listen) {
        if (this.serialListen != null) {
            this.serialListen.doStop();
        }
        if (listen != null && this.controlLineFlags != 0) {
            this.serialListen = new SerialStateListener(listen);
            new Thread((Runnable)this.serialListen, "SerialListen-" + this.portName).start();
        }
    }

    public String getPortName() {
        return this.portName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postSerialChangedEvent(SerialLineState newState) {
        if (!this.state.equals(newState)) {
            SerialLineState oldState = this.state;
            boolean update = false;
            this.state = newState;
            if (oldState.carrierDetect != newState.carrierDetect && (this.controlLineFlags & 3) != 0) {
                update = true;
            }
            if (oldState.clearToSend != newState.clearToSend && (this.controlLineFlags & 4) != 0) {
                update = true;
            }
            if (oldState.dataSetReady != newState.dataSetReady && (this.controlLineFlags & 5) != 0) {
                update = true;
            }
            if (oldState.dataTerminalReady != newState.dataTerminalReady && (this.controlLineFlags & 1) != 0) {
                update = true;
            }
            if (oldState.requestToSend != newState.requestToSend && (this.controlLineFlags & 2) != 0) {
                update = true;
            }
            if (oldState.ringIndicator != newState.ringIndicator && (this.controlLineFlags & 6) != 0) {
                update = true;
            }
            if (update) {
                Object object = this.serialListenSync;
                synchronized (object) {
                    this.serialListenSync.notify();
                }
            }
        }
    }

    private native int openPort(String var1, int var2, int var3, int var4, int var5, int var6) throws NoSuchPortException, NotASerialPortException, IOException;

    private native int openPort(String var1) throws NoSuchPortException, NotASerialPortException, IOException;

    private native void doClose();

    private native boolean setBaudRate(int var1) throws IOException;

    private native int getBaudRateInternal() throws IOException;

    private native boolean setStopBits(int var1) throws IOException;

    private native int getStopBitsInternal() throws IOException;

    private native boolean setCharSize(int var1) throws IOException;

    private native int getCharSizeInternal() throws IOException;

    private native boolean setParity(int var1) throws IOException;

    private native int getParityInternal() throws IOException;

    private native boolean setFlowControl(int var1) throws IOException;

    private native int getFlowControlInternal() throws IOException;

    protected native int getSerialLineStateInternalNonblocking() throws IOException;

    private native int setSerialLineStateInternal(SerialLineState var1) throws IOException;

    public static int getMajorVersion() {
        return 0;
    }

    public static int getMinorVersion() {
        return 13;
    }

    public static native int getMajorNativeVersion();

    public static native int getMinorNativeVersion();

    public static native String[] getSerialPorts() throws IOException;

    static {
        SerialPort.loadNativeLibrary();
    }

    public static enum FlowControl {
        NONE(0),
        HARDWARE(1),
        SOFTWARE(2);

        private final int m_flowControl;

        private FlowControl(int flowControl) {
            this.m_flowControl = flowControl;
        }

        public int getFlowControl() {
            return this.m_flowControl;
        }
    }

    public static enum Parity {
        NONE(0),
        ODD(1),
        EVEN(2);

        private final int m_parity;

        private Parity(int parity) {
            this.m_parity = parity;
        }

        public int getParity() {
            return this.m_parity;
        }
    }

    public static enum StopBits {
        STOPBITS_1(1),
        STOPBITS_2(2);

        private final int m_stopBits;

        private StopBits(int stopBits) {
            this.m_stopBits = stopBits;
        }

        public int getStopBits() {
            return this.m_stopBits;
        }
    }

    public static enum DataBits {
        DATABITS_5(5),
        DATABITS_6(6),
        DATABITS_7(7),
        DATABITS_8(8);

        private final int m_dataBits;

        private DataBits(int dataBits) {
            this.m_dataBits = dataBits;
        }

        public int getDataBits() {
            return this.m_dataBits;
        }
    }

    public static enum BaudRate {
        B0(0),
        B50(50),
        B75(75),
        B110(110),
        B134(134),
        B150(150),
        B200(200),
        B300(300),
        B600(600),
        B1200(1200),
        B1800(1800),
        B2400(2400),
        B4800(4800),
        B9600(9600),
        B19200(19200),
        B38400(38400),
        B57600(57600),
        B115200(115200);

        private final int m_baudRate;

        private BaudRate(int baud) {
            this.m_baudRate = baud;
        }

        public int getBaudRate() {
            return this.m_baudRate;
        }
    }

    private class SerialStateListener
    implements Runnable {
        private volatile boolean stop = false;
        private SerialChangeListener listen;

        SerialStateListener(SerialChangeListener listen) {
            this.listen = listen;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.stop) {
                Object object = SerialPort.this.serialListenSync;
                synchronized (object) {
                    try {
                        SerialPort.this.serialListenSync.wait();
                        if (this.stop) {
                            break;
                        }
                        this.listen.serialStateChanged(SerialPort.this.state);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        void doStop() {
            this.stop = true;
        }
    }
}

