/*
 * Decompiled with CFR 0.152.
 */
package com.robrua.easyjava.graph;

import com.robrua.easyjava.graph.Graph;
import java.io.Serializable;

public abstract class GraphComponent
implements Serializable {
    private static final long serialVersionUID = -8383992780607555702L;
    private Graph<?> owningGraph;

    protected GraphComponent(Graph<?> owningGraph) {
        if (owningGraph == null) {
            throw new IllegalArgumentException("Owning Graph can't be null!");
        }
        this.owningGraph = owningGraph;
    }

    public boolean fromGraph(Graph<?> graph) {
        if (this.owningGraph == null) {
            return false;
        }
        return this.owningGraph.equals(graph);
    }

    public boolean fromSameGraphAs(GraphComponent component) {
        if (this.owningGraph == null) {
            return false;
        }
        return this.owningGraph.equals(component.owningGraph);
    }

    public void removeFromGraph() {
        this.owningGraph = null;
    }

    public String toString() {
        return "GraphComponent from " + this.owningGraph;
    }
}

