/*
 * Decompiled with CFR 0.152.
 */
package com.robrua.easyjava.graph.directed;

import com.robrua.easyjava.graph.Edge;
import com.robrua.easyjava.graph.Vertex;
import com.robrua.easyjava.graph.directed.DirectedGraph;
import com.robrua.easyjava.graph.directed.DirectedVertex;

public class DirectedEdge<T>
extends Edge<T> {
    private static final long serialVersionUID = -8517040038695255427L;
    private DirectedGraph<T> owningGraph;
    protected DirectedVertex<T> source;
    protected DirectedVertex<T> target;

    protected DirectedEdge(DirectedGraph<T> owningGraph, DirectedVertex<T> source, DirectedVertex<T> target) {
        super(owningGraph);
        this.owningGraph = owningGraph;
        if (source == null) {
            throw new IllegalArgumentException("Source can't be null!");
        }
        if (target == null) {
            throw new IllegalArgumentException("Target can't be null!");
        }
        if (!source.fromSameGraphAs(target)) {
            throw new IllegalArgumentException("Source and Target must be from the same graph!");
        }
        this.source = source;
        this.target = target;
    }

    public DirectedVertex<T> getSource() {
        return this.source;
    }

    public DirectedVertex<T> getTarget() {
        return this.target;
    }

    @Override
    public void removeFromGraph() {
        if (this.owningGraph == null) {
            return;
        }
        this.source.outgoingEdges.remove(this);
        this.target.incomingEdges.remove(this);
        this.source = null;
        this.target = null;
        this.owningGraph.edges.remove(this);
        this.owningGraph = null;
        super.removeFromGraph();
    }

    public void reverse() {
        DirectedVertex<T> target = this.target;
        this.setTarget(this.source);
        this.setSource(target);
    }

    public void setSource(Vertex<T> source) {
        if (source == null) {
            throw new IllegalArgumentException("Can't set source as null!");
        }
        if (!(source instanceof DirectedVertex)) {
            throw new IllegalArgumentException("Source vertex is of the wrong type!");
        }
        if (!source.fromSameGraphAs(this)) {
            throw new IllegalArgumentException("New source is not from the same graph!");
        }
        DirectedVertex src = (DirectedVertex)source;
        this.source.outgoingEdges.remove(this);
        src.outgoingEdges.add(this);
        this.source = src;
    }

    public void setTarget(Vertex<T> target) {
        if (target == null) {
            throw new IllegalArgumentException("Can't set target as null!");
        }
        if (!(target instanceof DirectedVertex)) {
            throw new IllegalArgumentException("Target vertex is of the wrong type!");
        }
        if (!target.fromSameGraphAs(this)) {
            throw new IllegalArgumentException("New target is not from the same graph!");
        }
        DirectedVertex tgt = (DirectedVertex)target;
        this.target.incomingEdges.remove(this);
        tgt.incomingEdges.add(this);
        this.target = tgt;
    }

    @Override
    public String toString() {
        return this.source + " -----> " + this.target;
    }
}

