/*
 * Decompiled with CFR 0.152.
 */
package com.robrua.easyjava.graph.directed;

import com.robrua.easyjava.graph.Graph;
import com.robrua.easyjava.graph.directed.DirectedEdge;
import com.robrua.easyjava.graph.directed.DirectedVertex;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public abstract class DirectedGraph<T>
implements Graph<T> {
    private static final long serialVersionUID = -1251829538151446709L;
    protected Set<DirectedEdge<T>> edges;
    protected Set<DirectedVertex<T>> vertices = new HashSet<DirectedVertex<T>>();

    public DirectedGraph() {
        this.edges = new HashSet<DirectedEdge<T>>();
    }

    public DirectedGraph(Collection<T> vertexData) {
        this();
        if (vertexData != null) {
            vertexData.forEach(data -> this.addVertex(data));
        }
    }

    @Override
    public Set<DirectedEdge<T>> getEdges() {
        return Collections.unmodifiableSet(this.edges);
    }

    @Override
    public Set<DirectedVertex<T>> getVertices() {
        return Collections.unmodifiableSet(this.vertices);
    }

    @Override
    public void removeAllEdges() {
        LinkedList<DirectedEdge<T>> edges = new LinkedList<DirectedEdge<T>>();
        edges.addAll(this.edges);
        while (!edges.isEmpty()) {
            ((DirectedEdge)edges.get(0)).removeFromGraph();
            edges.remove(0);
        }
    }

    @Override
    public void removeAllVertices() {
        LinkedList<DirectedVertex<T>> vertices = new LinkedList<DirectedVertex<T>>();
        vertices.addAll(this.vertices);
        while (!vertices.isEmpty()) {
            ((DirectedVertex)vertices.get(0)).removeFromGraph();
            vertices.remove(0);
        }
    }

    public String toString() {
        return "Directed graph containing " + this.vertices.size() + " vertices and " + this.edges.size() + " edges";
    }
}

