/*
 * Decompiled with CFR 0.152.
 */
package com.robrua.easyjava.graph.directed;

import com.robrua.easyjava.graph.Vertex;
import com.robrua.easyjava.graph.directed.DirectedEdge;
import com.robrua.easyjava.graph.directed.DirectedGraph;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class DirectedVertex<T>
extends Vertex<T> {
    private static final long serialVersionUID = 5158563791496209387L;
    protected Set<DirectedEdge<T>> incomingEdges;
    protected Set<DirectedEdge<T>> outgoingEdges;
    private DirectedGraph<T> owningGraph;

    protected DirectedVertex(DirectedGraph<T> owningGraph, T data) {
        super(owningGraph, data);
        this.owningGraph = owningGraph;
        this.incomingEdges = new HashSet<DirectedEdge<T>>();
        this.outgoingEdges = new HashSet<DirectedEdge<T>>();
    }

    @Override
    public Set<DirectedVertex<T>> getAdjacentVertices() {
        HashSet vertices = new HashSet();
        this.outgoingEdges.forEach(edge -> vertices.add(edge.getTarget()));
        this.incomingEdges.forEach(edge -> vertices.add(edge.getSource()));
        return Collections.unmodifiableSet(vertices);
    }

    @Override
    public Set<DirectedEdge<T>> getEdges() {
        HashSet<DirectedEdge<T>> edges = new HashSet<DirectedEdge<T>>();
        edges.addAll(this.incomingEdges);
        edges.addAll(this.outgoingEdges);
        return Collections.unmodifiableSet(edges);
    }

    public Set<DirectedVertex<T>> getIncomingAdjacentVertices() {
        HashSet vertices = new HashSet();
        this.incomingEdges.forEach(edge -> vertices.add(edge.getSource()));
        return Collections.unmodifiableSet(vertices);
    }

    public Set<DirectedEdge<T>> getIncomingEdges() {
        return Collections.unmodifiableSet(this.incomingEdges);
    }

    public Set<DirectedVertex<T>> getOutgoingAdjacentVertices() {
        HashSet vertices = new HashSet();
        this.outgoingEdges.forEach(edge -> vertices.add(edge.getTarget()));
        return Collections.unmodifiableSet(vertices);
    }

    public Set<DirectedEdge<T>> getOutgoingEdges() {
        return Collections.unmodifiableSet(this.outgoingEdges);
    }

    @Override
    public void removeAllEdges() {
        this.removeAllIncomingEdges();
        this.removeAllOutgoingEdges();
    }

    public void removeAllIncomingEdges() {
        this.incomingEdges.forEach(edge -> edge.removeFromGraph());
    }

    public void removeAllOutgoingEdges() {
        this.outgoingEdges.forEach(edge -> edge.removeFromGraph());
    }

    @Override
    public void removeFromGraph() {
        if (this.owningGraph == null) {
            return;
        }
        this.removeAllEdges();
        this.owningGraph.vertices.remove(this);
        this.owningGraph = null;
        super.removeFromGraph();
    }
}

