/*
 * Decompiled with CFR 0.152.
 */
package com.robrua.easyjava.graph.directed;

import com.robrua.easyjava.graph.UnweightedGraph;
import com.robrua.easyjava.graph.Vertex;
import com.robrua.easyjava.graph.directed.DirectedEdge;
import com.robrua.easyjava.graph.directed.DirectedGraph;
import com.robrua.easyjava.graph.directed.UnweightedDirectedVertex;
import com.robrua.easyjava.type.MultiMap;
import java.util.Collection;
import java.util.HashMap;

public class UnweightedDirectedGraph<T>
extends DirectedGraph<T>
implements UnweightedGraph<T> {
    private static final long serialVersionUID = 8379022390500653122L;

    public UnweightedDirectedGraph() {
    }

    public UnweightedDirectedGraph(Collection<T> vertexData) {
        super(vertexData);
    }

    public UnweightedDirectedGraph(MultiMap<T, T> connections) {
        this();
        HashMap dataVertices = new HashMap();
        connections.forEach((fromData, toData) -> {
            Vertex toVertex;
            Vertex fromVertex = (UnweightedDirectedVertex)dataVertices.get(fromData);
            if (fromVertex == null) {
                fromVertex = this.addVertex(fromData);
                dataVertices.put(fromData, fromVertex);
            }
            if ((toVertex = (UnweightedDirectedVertex)dataVertices.get(toData)) == null) {
                toVertex = this.addVertex(toData);
                dataVertices.put(toData, toVertex);
            }
            this.addEdge(fromVertex, toVertex);
        });
    }

    @Override
    public DirectedEdge<T> addEdge(Vertex<T> source, Vertex<T> target) {
        if (!(source instanceof UnweightedDirectedVertex)) {
            throw new IllegalArgumentException("Source vertex is of the wrong type!");
        }
        if (!(target instanceof UnweightedDirectedVertex)) {
            throw new IllegalArgumentException("Target vertex is of the wrong type!");
        }
        UnweightedDirectedVertex src = (UnweightedDirectedVertex)source;
        UnweightedDirectedVertex tgt = (UnweightedDirectedVertex)target;
        DirectedEdge edge = new DirectedEdge(this, src, tgt);
        src.outgoingEdges.add(edge);
        tgt.incomingEdges.add(edge);
        this.edges.add(edge);
        return edge;
    }

    @Override
    public UnweightedDirectedVertex<T> addVertex(T data) {
        UnweightedDirectedVertex<T> vertex = new UnweightedDirectedVertex<T>(this, data);
        this.vertices.add(vertex);
        return vertex;
    }
}

