/*
 * Decompiled with CFR 0.152.
 */
package com.robrua.easyjava.graph.directed;

import com.robrua.easyjava.graph.Vertex;
import com.robrua.easyjava.graph.WeightedGraph;
import com.robrua.easyjava.graph.directed.DirectedGraph;
import com.robrua.easyjava.graph.directed.WeightedDirectedEdge;
import com.robrua.easyjava.graph.directed.WeightedDirectedVertex;
import com.robrua.easyjava.type.MultiMap;
import com.robrua.easyjava.type.Pair;
import java.util.Collection;
import java.util.HashMap;

public class WeightedDirectedGraph<T>
extends DirectedGraph<T>
implements WeightedGraph<T> {
    private static final long serialVersionUID = 7335861539626736060L;

    public WeightedDirectedGraph() {
    }

    public WeightedDirectedGraph(Collection<T> vertexData) {
    }

    public WeightedDirectedGraph(MultiMap<T, Pair<T, Double>> connections) {
        this();
        HashMap dataVertices = new HashMap();
        connections.forEach((fromData, toData) -> {
            Vertex toVertex;
            Vertex fromVertex = (WeightedDirectedVertex)dataVertices.get(fromData);
            if (fromVertex == null) {
                fromVertex = this.addVertex(fromData);
                dataVertices.put(fromData, fromVertex);
            }
            if ((toVertex = (WeightedDirectedVertex)dataVertices.get(toData.getLeft())) == null) {
                toVertex = this.addVertex(toData.getLeft());
                dataVertices.put(toData.getLeft(), toVertex);
            }
            this.addEdge(fromVertex, toVertex, (double)((Double)toData.getRight()));
        });
    }

    @Override
    public WeightedDirectedEdge<T> addEdge(Vertex<T> source, Vertex<T> target, double weight) {
        if (!(source instanceof WeightedDirectedVertex)) {
            throw new IllegalArgumentException("Source vertex is of the wrong type!");
        }
        if (!(target instanceof WeightedDirectedVertex)) {
            throw new IllegalArgumentException("Target vertex is of the wrong type!");
        }
        WeightedDirectedVertex src = (WeightedDirectedVertex)source;
        WeightedDirectedVertex tgt = (WeightedDirectedVertex)target;
        WeightedDirectedEdge edge = new WeightedDirectedEdge(this, src, tgt, weight);
        src.outgoingEdges.add(edge);
        tgt.incomingEdges.add(edge);
        this.edges.add(edge);
        return edge;
    }

    @Override
    public WeightedDirectedVertex<T> addVertex(T data) {
        WeightedDirectedVertex<T> vertex = new WeightedDirectedVertex<T>(this, data);
        this.vertices.add(vertex);
        return vertex;
    }
}

