/*
 * Decompiled with CFR 0.152.
 */
package com.robrua.easyjava.graph.undirected;

import com.robrua.easyjava.graph.Edge;
import com.robrua.easyjava.graph.undirected.UndirectedGraph;
import com.robrua.easyjava.graph.undirected.UndirectedVertex;
import com.robrua.easyjava.type.Pair;
import com.robrua.easyjava.type.UnmodifiablePair;

public class UndirectedEdge<T>
extends Edge<T> {
    private static final long serialVersionUID = 248305893855449674L;
    private UndirectedGraph<T> owningGraph;
    protected final Pair<UndirectedVertex<T>, UndirectedVertex<T>> vertices;

    protected UndirectedEdge(UndirectedGraph<T> owningGraph, UndirectedVertex<T> one, UndirectedVertex<T> other) {
        super(owningGraph);
        this.owningGraph = owningGraph;
        if (one == null) {
            throw new IllegalArgumentException("First vertex can't be null!");
        }
        if (other == null) {
            throw new IllegalArgumentException("Second vertex can't be null!");
        }
        if (!one.fromSameGraphAs(other)) {
            throw new IllegalArgumentException("Both vertices must be from the same graph!");
        }
        this.vertices = new Pair<UndirectedVertex<T>, UndirectedVertex<T>>(one, other);
    }

    public UndirectedVertex<T> getOtherVertex(UndirectedVertex<T> one) {
        if (this.vertices.getLeft().equals(one)) {
            return this.vertices.getRight();
        }
        return this.vertices.getLeft();
    }

    public UnmodifiablePair<UndirectedVertex<T>, UndirectedVertex<T>> getVertices() {
        return new UnmodifiablePair<UndirectedVertex<T>, UndirectedVertex<T>>(this.vertices);
    }

    @Override
    public void removeFromGraph() {
        if (this.owningGraph == null) {
            return;
        }
        this.vertices.getLeft().edges.remove(this);
        this.vertices.getRight().edges.remove(this);
        this.vertices.setLeft(null);
        this.vertices.setRight(null);
        this.owningGraph.edges.remove(this);
        this.owningGraph = null;
        super.removeFromGraph();
    }

    public void replaceVertex(UndirectedVertex<T> oldVertex, UndirectedVertex<T> newVertex) {
        if (newVertex == null) {
            throw new IllegalArgumentException("New vertex can't be null!");
        }
        if (this.vertices.getLeft().equals(oldVertex)) {
            oldVertex.edges.remove(this);
            newVertex.edges.add(this);
            this.vertices.setLeft(newVertex);
        } else if (this.vertices.getRight().equals(oldVertex)) {
            oldVertex.edges.remove(this);
            newVertex.edges.add(this);
            this.vertices.setRight(newVertex);
        } else {
            throw new IllegalArgumentException("Can't replace a vertex that doesn't touch the edge!");
        }
    }

    @Override
    public String toString() {
        return this.vertices.getLeft() + " ----- " + this.vertices.getRight();
    }
}

