/*
 * Decompiled with CFR 0.152.
 */
package com.robrua.easyjava.graph.undirected;

import com.robrua.easyjava.graph.Graph;
import com.robrua.easyjava.graph.undirected.UndirectedEdge;
import com.robrua.easyjava.graph.undirected.UndirectedVertex;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public abstract class UndirectedGraph<T>
implements Graph<T> {
    private static final long serialVersionUID = -6375554997375694215L;
    protected Set<UndirectedEdge<T>> edges;
    protected Set<UndirectedVertex<T>> vertices = new HashSet<UndirectedVertex<T>>();

    public UndirectedGraph() {
        this.edges = new HashSet<UndirectedEdge<T>>();
    }

    public UndirectedGraph(Collection<T> vertexData) {
        this();
        if (vertexData != null) {
            vertexData.forEach(data -> this.addVertex(data));
        }
    }

    @Override
    public Set<UndirectedEdge<T>> getEdges() {
        return Collections.unmodifiableSet(this.edges);
    }

    @Override
    public Set<UndirectedVertex<T>> getVertices() {
        return Collections.unmodifiableSet(this.vertices);
    }

    @Override
    public void removeAllEdges() {
        LinkedList<UndirectedEdge<T>> edges = new LinkedList<UndirectedEdge<T>>();
        edges.addAll(this.edges);
        while (!edges.isEmpty()) {
            ((UndirectedEdge)edges.get(0)).removeFromGraph();
            edges.remove(0);
        }
    }

    @Override
    public void removeAllVertices() {
        LinkedList<UndirectedVertex<T>> vertices = new LinkedList<UndirectedVertex<T>>();
        vertices.addAll(this.vertices);
        while (!vertices.isEmpty()) {
            ((UndirectedVertex)vertices.get(0)).removeFromGraph();
            vertices.remove(0);
        }
    }

    public String toString() {
        return "Undirected graph containing " + this.vertices.size() + " vertices and " + this.edges.size() + " edges";
    }
}

