/*
 * Decompiled with CFR 0.152.
 */
package com.robrua.easyjava.graph.undirected;

import com.robrua.easyjava.graph.Vertex;
import com.robrua.easyjava.graph.undirected.UndirectedEdge;
import com.robrua.easyjava.graph.undirected.UndirectedGraph;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class UndirectedVertex<T>
extends Vertex<T> {
    private static final long serialVersionUID = -4366930308063326198L;
    protected Set<UndirectedEdge<T>> edges;
    private UndirectedGraph<T> owningGraph;

    protected UndirectedVertex(UndirectedGraph<T> owningGraph, T data) {
        super(owningGraph, data);
        this.owningGraph = owningGraph;
        this.edges = new HashSet<UndirectedEdge<T>>();
    }

    @Override
    public Set<UndirectedVertex<T>> getAdjacentVertices() {
        HashSet vertices = new HashSet();
        this.edges.forEach(edge -> vertices.add(edge.getOtherVertex(this)));
        return Collections.unmodifiableSet(vertices);
    }

    @Override
    public Set<UndirectedEdge<T>> getEdges() {
        return Collections.unmodifiableSet(this.edges);
    }

    @Override
    public void removeAllEdges() {
        this.edges.forEach(edge -> edge.removeFromGraph());
    }

    @Override
    public void removeFromGraph() {
        if (this.owningGraph == null) {
            return;
        }
        this.removeAllEdges();
        this.owningGraph.vertices.remove(this);
        this.owningGraph = null;
        super.removeFromGraph();
    }
}

