/*
 * Decompiled with CFR 0.152.
 */
package com.robrua.easyjava.graph.undirected;

import com.robrua.easyjava.graph.UnweightedGraph;
import com.robrua.easyjava.graph.Vertex;
import com.robrua.easyjava.graph.undirected.UndirectedEdge;
import com.robrua.easyjava.graph.undirected.UndirectedGraph;
import com.robrua.easyjava.graph.undirected.UnweightedUndirectedVertex;
import com.robrua.easyjava.type.MultiMap;
import java.util.Collection;
import java.util.HashMap;

public class UnweightedUndirectedGraph<T>
extends UndirectedGraph<T>
implements UnweightedGraph<T> {
    private static final long serialVersionUID = 8429115724026735057L;

    public UnweightedUndirectedGraph() {
    }

    public UnweightedUndirectedGraph(Collection<T> vertexData) {
        super(vertexData);
    }

    public UnweightedUndirectedGraph(MultiMap<T, T> connections) {
        this();
        HashMap dataVertices = new HashMap();
        connections.forEach((fromData, toData) -> {
            Vertex toVertex;
            Vertex fromVertex = (UnweightedUndirectedVertex)dataVertices.get(fromData);
            if (fromVertex == null) {
                fromVertex = this.addVertex(fromData);
                dataVertices.put(fromData, fromVertex);
            }
            if ((toVertex = (UnweightedUndirectedVertex)dataVertices.get(toData)) == null) {
                toVertex = this.addVertex(toData);
                dataVertices.put(toData, toVertex);
            }
            this.addEdge(fromVertex, toVertex);
        });
    }

    @Override
    public UndirectedEdge<T> addEdge(Vertex<T> one, Vertex<T> other) {
        if (!(one instanceof UnweightedUndirectedVertex)) {
            throw new IllegalArgumentException("First vertex is of the wrong type!");
        }
        if (!(other instanceof UnweightedUndirectedVertex)) {
            throw new IllegalArgumentException("Second vertex is of the wrong type!");
        }
        UnweightedUndirectedVertex a = (UnweightedUndirectedVertex)one;
        UnweightedUndirectedVertex b = (UnweightedUndirectedVertex)other;
        UndirectedEdge edge = new UndirectedEdge(this, a, b);
        a.edges.add(edge);
        b.edges.add(edge);
        this.edges.add(edge);
        return edge;
    }

    @Override
    public UnweightedUndirectedVertex<T> addVertex(T data) {
        UnweightedUndirectedVertex<T> vertex = new UnweightedUndirectedVertex<T>(this, data);
        this.vertices.add(vertex);
        return vertex;
    }
}

