/*
 * Decompiled with CFR 0.152.
 */
package com.robrua.easyjava.graph.undirected;

import com.robrua.easyjava.graph.Vertex;
import com.robrua.easyjava.graph.WeightedGraph;
import com.robrua.easyjava.graph.undirected.UndirectedGraph;
import com.robrua.easyjava.graph.undirected.WeightedUndirectedEdge;
import com.robrua.easyjava.graph.undirected.WeightedUndirectedVertex;
import com.robrua.easyjava.type.MultiMap;
import com.robrua.easyjava.type.Pair;
import java.util.Collection;
import java.util.HashMap;

public class WeightedUndirectedGraph<T>
extends UndirectedGraph<T>
implements WeightedGraph<T> {
    private static final long serialVersionUID = -407448011159008950L;

    public WeightedUndirectedGraph() {
    }

    public WeightedUndirectedGraph(Collection<T> vertexData) {
    }

    public WeightedUndirectedGraph(MultiMap<T, Pair<T, Double>> connections) {
        this();
        HashMap dataVertices = new HashMap();
        connections.forEach((fromData, toData) -> {
            Vertex toVertex;
            Vertex fromVertex = (WeightedUndirectedVertex)dataVertices.get(fromData);
            if (fromVertex == null) {
                fromVertex = this.addVertex(fromData);
                dataVertices.put(fromData, fromVertex);
            }
            if ((toVertex = (WeightedUndirectedVertex)dataVertices.get(toData.getLeft())) == null) {
                toVertex = this.addVertex(toData.getLeft());
                dataVertices.put(toData.getLeft(), toVertex);
            }
            this.addEdge(fromVertex, toVertex, (double)((Double)toData.getRight()));
        });
    }

    @Override
    public WeightedUndirectedEdge<T> addEdge(Vertex<T> one, Vertex<T> other, double weight) {
        if (!(one instanceof WeightedUndirectedVertex)) {
            throw new IllegalArgumentException(" vertex is of the wrong type!");
        }
        if (!(other instanceof WeightedUndirectedVertex)) {
            throw new IllegalArgumentException("other vertex is of the wrong type!");
        }
        WeightedUndirectedVertex a = (WeightedUndirectedVertex)one;
        WeightedUndirectedVertex b = (WeightedUndirectedVertex)other;
        WeightedUndirectedEdge edge = new WeightedUndirectedEdge(this, a, b, weight);
        a.edges.add(edge);
        b.edges.add(edge);
        this.edges.add(edge);
        return edge;
    }

    @Override
    public WeightedUndirectedVertex<T> addVertex(T data) {
        WeightedUndirectedVertex<T> vertex = new WeightedUndirectedVertex<T>(this, data);
        this.vertices.add(vertex);
        return vertex;
    }
}

