/*
 * Decompiled with CFR 0.152.
 */
package com.robrua.easyjava.io.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Iterator;

public class FileReader
implements Iterable<String> {
    private final File file;
    private long lineNumber;
    private BufferedReader reader;

    public static String readFile(File file) throws IOException {
        FileReader reader = new FileReader(file);
        String text = reader.readFile();
        reader.close();
        return text;
    }

    public static String readFile(String filePath) throws IOException {
        return FileReader.readFile(new File(filePath));
    }

    public static Object readSerializedFile(File file) throws IOException, ClassNotFoundException {
        ObjectInputStream reader = new ObjectInputStream(new FileInputStream(file));
        Object object = reader.readObject();
        reader.close();
        return object;
    }

    public static Object readSerializedFile(String filePath) throws IOException, ClassNotFoundException {
        return FileReader.readSerializedFile(new File(filePath));
    }

    public FileReader(File file) throws FileNotFoundException {
        this.file = file;
        this.reader = new BufferedReader(new java.io.FileReader(file));
    }

    public FileReader(String filePath) throws FileNotFoundException {
        this(new File(filePath));
    }

    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public Iterator<String> iterator() {
        return this.reader.lines().iterator();
    }

    public String readFile() throws IOException {
        if (this.lineNumber != 0L) {
            this.reopen();
        }
        return this.readRestOfFile();
    }

    public String readLine() throws IOException {
        ++this.lineNumber;
        return this.reader.readLine();
    }

    public String readRestOfFile() throws IOException {
        String line;
        StringBuilder sb = new StringBuilder();
        while ((line = this.readLine()) != null) {
            sb.append(line + "\n");
        }
        return sb.toString();
    }

    public void reopen() throws FileNotFoundException {
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.reader = new BufferedReader(new java.io.FileReader(this.file));
    }

    public String toString() {
        return "FileReader(" + this.file.getAbsolutePath() + ")";
    }
}

