/*
 * Decompiled with CFR 0.152.
 */
package com.robrua.easyjava.io.file;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class FileWriter {
    private File file;
    private BufferedWriter writer;

    public static void writeFile(File targetFile, String content) throws IOException {
        FileWriter writer = new FileWriter(targetFile);
        writer.write(content);
        writer.close();
    }

    public static void writeFile(String targetFilePath, String content) throws IOException {
        FileWriter.writeFile(new File(targetFilePath), content);
    }

    public static void writeSerializedFile(File targetFile, Serializable content) throws IOException {
        if (targetFile != null && targetFile.getParentFile() != null && !targetFile.getParentFile().exists()) {
            targetFile.getParentFile().mkdirs();
        }
        ObjectOutputStream writer = new ObjectOutputStream(new FileOutputStream(targetFile));
        writer.writeObject(content);
        writer.close();
    }

    public static void writeSerializedFile(String targetFilePath, Serializable content) throws IOException {
        FileWriter.writeSerializedFile(new File(targetFilePath), content);
    }

    public FileWriter(File file) throws IOException {
        this(file, false);
    }

    public FileWriter(File file, boolean append) throws IOException {
        if (file != null && file.getParentFile() != null && !file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        this.writer = new BufferedWriter(new java.io.FileWriter(file, append));
    }

    public FileWriter(String filePath) throws IOException {
        this(filePath, false);
    }

    public FileWriter(String filePath, boolean append) throws IOException {
        this(new File(filePath), append);
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public void reopen() throws IOException {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.writer = new BufferedWriter(new java.io.FileWriter(this.file));
    }

    public String toString() {
        return "FileWriter(" + this.file.getAbsolutePath() + ")";
    }

    public void write(String text) throws IOException {
        this.writer.write(text);
        this.writer.flush();
    }

    public void writeLine(String text) throws IOException {
        this.write(text + "\n");
    }
}

