/*
 * Decompiled with CFR 0.152.
 */
package com.robrua.easyjava.io.output;

import com.robrua.easyjava.io.file.FileWriter;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;

public class Logger {
    private static final String DEFAULT_LOG_FILE = "default.log";
    private static final Map<File, Logger> instances = new HashMap<File, Logger>();
    private static Level staticLevel = Level.OUTPUT;
    private static boolean staticOnly = false;
    private static FileWriter staticWriter;
    private Level level;
    private boolean only;
    private FileWriter writer;

    public static void closeDefaultLogger() {
        if (staticWriter != null) {
            try {
                staticWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            staticWriter = null;
        }
    }

    public static void defaultError(Exception exception) {
        Logger.defaultLog(exception, Level.ERROR);
    }

    public static void defaultError(String content) {
        Logger.defaultLog(content, Level.ERROR);
    }

    public static void defaultFatal(Exception exception) {
        Logger.defaultLog(exception, Level.FATAL);
    }

    public static void defaultFatal(String content) {
        Logger.defaultLog(content, Level.FATAL);
    }

    public static void defaultLog(Exception exception, Level level) {
        Logger.defaultLog(exception.toString(), level);
    }

    public static void defaultLog(String content, Level level) {
        if (staticLevel == Level.NULL) {
            return;
        }
        if (staticWriter == null) {
            try {
                staticWriter = new FileWriter(DEFAULT_LOG_FILE, false);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (level == staticLevel || !staticOnly && level.importance > staticLevel.importance) {
            try {
                staticWriter.writeLine(LocalDateTime.now() + " - " + (Object)((Object)level) + " - " + content);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void defaultOutput(Exception exception) {
        Logger.defaultLog(exception, Level.OUTPUT);
    }

    public static void defaultOutput(String content) {
        Logger.defaultLog(content, Level.OUTPUT);
    }

    public static void defaultVerbose(Exception exception) {
        Logger.defaultLog(exception, Level.VERBOSE);
    }

    public static void defaultVerbose(String content) {
        Logger.defaultLog(content, Level.VERBOSE);
    }

    public static void defaultWarn(Exception exception) {
        Logger.defaultLog(exception, Level.WARN);
    }

    public static void defaultWarn(String content) {
        Logger.defaultLog(content, Level.WARN);
    }

    public static Logger getLogger(File file) throws IOException {
        Logger logger = instances.get(file);
        if (logger == null) {
            logger = new Logger(file);
        }
        return logger;
    }

    public static Logger getLogger(String filePath) throws IOException {
        return Logger.getLogger(new File(filePath));
    }

    public static Logger nullLogger() {
        Logger logger = null;
        try {
            logger = new Logger(Level.NULL);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return logger;
    }

    public static void setDefaultLevel(Level level, boolean only) {
        staticLevel = level;
        staticOnly = only;
    }

    public Logger() throws IOException {
        this((File)null, false, Level.OUTPUT, false);
    }

    public Logger(File file) throws IOException {
        this(file, true, Level.OUTPUT, false);
    }

    public Logger(File file, boolean append) throws IOException {
        this(file, append, Level.OUTPUT, false);
    }

    public Logger(File file, boolean append, Level level) throws IOException {
        this(file, append, level, false);
    }

    public Logger(File file, boolean append, Level level, boolean only) throws IOException {
        if (file != null) {
            this.writer = new FileWriter(file, append);
        }
        this.level = level;
        this.only = only;
        instances.put(file, this);
    }

    public Logger(Level level) throws IOException {
        this((File)null, false, level, false);
    }

    public Logger(Level level, boolean only) throws IOException {
        this((File)null, false, level, only);
    }

    public Logger(String filePath) throws IOException {
        this(filePath, true, Level.OUTPUT, false);
    }

    public Logger(String filePath, boolean append) throws IOException {
        this(filePath, append, Level.OUTPUT, false);
    }

    public Logger(String filePath, boolean append, Level level) throws IOException {
        this(filePath, append, level, false);
    }

    public Logger(String filePath, boolean append, Level level, boolean only) throws IOException {
        this(new File(filePath), append, level, only);
    }

    public void close() {
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void error(Exception exception) {
        this.log(exception, Level.ERROR);
    }

    public void error(String content) {
        this.log(content, Level.ERROR);
    }

    public void fatal(Exception exception) {
        this.log(exception, Level.FATAL);
    }

    public void fatal(String content) {
        this.log(content, Level.FATAL);
    }

    public void log(Exception exception, Level level) {
        this.log(exception.toString(), level);
    }

    public void log(String content, Level level) {
        if (this.level == Level.NULL) {
            return;
        }
        if (this.writer == null) {
            System.err.println(content);
            return;
        }
        if (level == this.level || !this.only && level.importance > this.level.importance) {
            try {
                this.writer.writeLine(LocalDateTime.now() + " - " + (Object)((Object)level) + " - " + content);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void output(Exception exception) {
        this.log(exception, Level.OUTPUT);
    }

    public void output(String content) {
        this.log(content, Level.OUTPUT);
    }

    public void setLevel(Level level, boolean only) {
        this.level = level;
        this.only = only;
    }

    public void verbose(Exception exception) {
        this.log(exception, Level.VERBOSE);
    }

    public void verbose(String content) {
        this.log(content, Level.VERBOSE);
    }

    public void warn(Exception exception) {
        this.log(exception, Level.WARN);
    }

    public void warn(String content) {
        this.log(content, Level.WARN);
    }

    public static enum Level {
        ERROR(3),
        FATAL(4),
        NULL(5),
        OUTPUT(1),
        VERBOSE(0),
        WARN(2);

        private final int importance;

        private Level(int importance) {
            this.importance = importance;
        }

        public int getImportance() {
            return this.importance;
        }
    }
}

