/*
 * Decompiled with CFR 0.152.
 */
package com.robrua.easyjava.io.output;

public class ProgressPrinter {
    private long count;
    private final long dotsPerLine;
    private long lineSoFar;
    private double nextSegment;
    private final long numTicks;
    private final String postfix;
    private final String prefix;
    private double segment;

    public ProgressPrinter(long numTicks, long numDots, long dotsPerLine) {
        this(numTicks, numDots, dotsPerLine, "", "");
    }

    public ProgressPrinter(long numTicks, long numDots, long dotsPerLine, String prefix) {
        this(numTicks, numDots, dotsPerLine, prefix, "");
    }

    public ProgressPrinter(long numTicks, long numDots, long dotsPerLine, String prefix, String postfix) {
        this.prefix = prefix;
        this.postfix = postfix;
        this.numTicks = numTicks;
        this.dotsPerLine = dotsPerLine;
        this.segment = (double)numTicks / (double)numDots;
        if (this.segment == 0.0) {
            this.segment = 1.0;
        }
        this.count = 0L;
        this.lineSoFar = 0L;
        this.nextSegment = this.segment;
        System.out.print(prefix);
    }

    public void tick() {
        ++this.count;
        while ((double)this.count >= this.nextSegment) {
            System.out.print(".");
            this.nextSegment += this.segment;
            ++this.lineSoFar;
            if (this.lineSoFar != this.dotsPerLine) continue;
            System.out.println(this.postfix);
            if (this.count < this.numTicks) {
                System.out.print(this.prefix);
            }
            this.lineSoFar = 0L;
        }
        if (this.count == this.numTicks && this.lineSoFar > 0L) {
            System.out.println(".");
        }
    }

    public String toString() {
        return "ProgressPrinter(" + this.count + "/" + this.numTicks + ")";
    }
}

