/*
 * Decompiled with CFR 0.152.
 */
package com.robrua.easyjava.math.function;

import com.robrua.easyjava.math.function.DifferentiableFunction;
import com.robrua.easyjava.math.function.IntegrableFunction;
import com.robrua.easyjava.math.function.UnivariateFunction;
import java.io.Serializable;
import java.util.Arrays;

public class UnivariatePolynomialFunction
implements DifferentiableFunction,
IntegrableFunction,
UnivariateFunction,
Serializable {
    private static final long serialVersionUID = -9139507880345934766L;
    private double[] coefficients;

    public UnivariatePolynomialFunction(double ... coefficients) {
        if (coefficients == null || coefficients.length < 1) {
            this.coefficients = new double[1];
            this.coefficients[0] = 0.0;
            return;
        }
        this.trimAndSetCoefficients((double[])coefficients.clone());
    }

    public void add(UnivariatePolynomialFunction f) {
        double[] coefficients = new double[Math.max(this.coefficients.length, f.coefficients.length)];
        for (int i = 0; i < coefficients.length; ++i) {
            if (i < this.coefficients.length) {
                int n = coefficients.length - i - 1;
                coefficients[n] = coefficients[n] + this.coefficients[this.coefficients.length - i - 1];
            }
            if (i >= f.coefficients.length) continue;
            int n = coefficients.length - i - 1;
            coefficients[n] = coefficients[n] + f.coefficients[f.coefficients.length - i - 1];
        }
        this.trimAndSetCoefficients(coefficients);
    }

    @Override
    public boolean continuous(double lowerBound, double upperBound) {
        return true;
    }

    public int degree() {
        return this.coefficients.length - 1;
    }

    @Override
    public UnivariatePolynomialFunction derivative() {
        double[] coefficients = new double[this.coefficients.length - 1];
        for (int i = 0; i < coefficients.length; ++i) {
            coefficients[i] = this.coefficients[i] * (double)(coefficients.length - i);
        }
        return new UnivariatePolynomialFunction(coefficients);
    }

    @Override
    public void derive() {
        double[] coefficients = new double[this.coefficients.length - 1];
        for (int i = 0; i < coefficients.length; ++i) {
            coefficients[i] = this.coefficients[i] * (double)(coefficients.length - i);
        }
        this.trimAndSetCoefficients(coefficients);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnivariatePolynomialFunction)) {
            return false;
        }
        UnivariatePolynomialFunction other = (UnivariatePolynomialFunction)obj;
        return Arrays.equals(this.coefficients, other.coefficients);
    }

    @Override
    public double evaluate(double x) {
        double val = 0.0;
        for (int i = 0; i < this.coefficients.length; ++i) {
            val += this.coefficients[this.coefficients.length - i - 1] * Math.pow(x, i);
        }
        return val;
    }

    public double[] getCoefficients() {
        return (double[])this.coefficients.clone();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.coefficients);
        return result;
    }

    @Override
    public UnivariatePolynomialFunction integral() {
        double[] coefficients = new double[this.coefficients.length + 1];
        for (int i = 0; i < this.coefficients.length; ++i) {
            coefficients[i] = this.coefficients[i] / (double)(this.coefficients.length - i);
        }
        return new UnivariatePolynomialFunction(coefficients);
    }

    @Override
    public void integrate() {
        double[] coefficients = new double[this.coefficients.length + 1];
        for (int i = 0; i < this.coefficients.length; ++i) {
            coefficients[i] = this.coefficients[i] / (double)(this.coefficients.length - i);
        }
        this.trimAndSetCoefficients(coefficients);
    }

    public UnivariatePolynomialFunction minus(UnivariatePolynomialFunction f) {
        return this.plus(f.opposite());
    }

    public void multiply(UnivariatePolynomialFunction f) {
        double[] coefficients = new double[this.coefficients.length + f.coefficients.length - 1];
        for (int i = 0; i < this.coefficients.length; ++i) {
            for (int j = 0; j < f.coefficients.length; ++j) {
                int n = coefficients.length - 1 - (i + j);
                coefficients[n] = coefficients[n] + this.coefficients[this.coefficients.length - 1 - i] * f.coefficients[f.coefficients.length - 1 - j];
            }
        }
        this.trimAndSetCoefficients(coefficients);
    }

    public UnivariatePolynomialFunction opposite() {
        double[] coefficients = new double[this.coefficients.length];
        for (int i = 0; i < coefficients.length; ++i) {
            coefficients[i] = -this.coefficients[i];
        }
        return new UnivariatePolynomialFunction(coefficients);
    }

    public UnivariatePolynomialFunction plus(UnivariatePolynomialFunction f) {
        double[] coefficients = new double[Math.max(this.coefficients.length, f.coefficients.length)];
        for (int i = 0; i < coefficients.length; ++i) {
            if (i < this.coefficients.length) {
                int n = coefficients.length - i - 1;
                coefficients[n] = coefficients[n] + this.coefficients[this.coefficients.length - i - 1];
            }
            if (i >= f.coefficients.length) continue;
            int n = coefficients.length - i - 1;
            coefficients[n] = coefficients[n] + f.coefficients[f.coefficients.length - i - 1];
        }
        return new UnivariatePolynomialFunction(coefficients);
    }

    public void reverse() {
        for (int i = 0; i < this.coefficients.length; ++i) {
            this.coefficients[i] = -this.coefficients[i];
        }
    }

    public void subtract(UnivariatePolynomialFunction f) {
        this.add(f.opposite());
    }

    public UnivariatePolynomialFunction times(UnivariatePolynomialFunction f) {
        double[] coefficients = new double[this.coefficients.length + f.coefficients.length - 1];
        for (int i = 0; i < this.coefficients.length; ++i) {
            for (int j = 0; j < f.coefficients.length; ++j) {
                int n = coefficients.length - 1 - (i + j);
                coefficients[n] = coefficients[n] + this.coefficients[this.coefficients.length - 1 - i] * f.coefficients[f.coefficients.length - 1 - j];
            }
        }
        return new UnivariatePolynomialFunction(coefficients);
    }

    public String toString() {
        int i;
        for (i = 0; i < this.coefficients.length && this.coefficients[i] == 0.0; ++i) {
        }
        if (i == this.coefficients.length) {
            return "0";
        }
        StringBuilder sb = new StringBuilder();
        while (i < this.coefficients.length - 1) {
            if (this.coefficients[i] != 0.0) {
                if (this.coefficients[i] > 0.0) {
                    sb.append(" + ");
                } else {
                    sb.append(" - ");
                }
                int power = this.coefficients.length - i - 1;
                sb.append((this.coefficients[i] + "x").replaceFirst("-", ""));
                if (power > 1) {
                    sb.append("^" + power);
                }
            }
            ++i;
        }
        if (this.coefficients[i] > 0.0) {
            sb.append(" + " + this.coefficients[i]);
        } else if (this.coefficients[i] < 0.0) {
            sb.append(" -" + (" " + this.coefficients[i]).replaceFirst("-", ""));
        }
        if (sb.charAt(1) == '+') {
            return sb.substring(3);
        }
        return "-" + sb.substring(3);
    }

    private void trimAndSetCoefficients(double[] coefficients) {
        int i;
        for (i = 0; i < coefficients.length - 1 && coefficients[i] == 0.0; ++i) {
        }
        if (i > 0) {
            this.coefficients = new double[coefficients.length - i];
            for (int j = i; j < coefficients.length; ++j) {
                this.coefficients[j - i] = coefficients[j];
            }
        } else {
            this.coefficients = coefficients;
        }
    }
}

