/*
 * Decompiled with CFR 0.152.
 */
package com.robrua.easyjava.math.stat;

import com.robrua.easyjava.math.function.UnivariatePolynomialFunction;
import java.util.ArrayList;

public class SimpleLinearRegressor {
    private final ArrayList<Double> xValues;
    private final ArrayList<Double> yValues;

    public static UnivariatePolynomialFunction regress(double[] xValues, double[] yValues) {
        return new SimpleLinearRegressor(xValues, yValues).regress();
    }

    public SimpleLinearRegressor() {
        this.xValues = new ArrayList();
        this.yValues = new ArrayList();
    }

    public SimpleLinearRegressor(double[] xValues, double[] yValues) {
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("xValues and yValues must have same number of entries!");
        }
        int initialSize = xValues.length;
        if (initialSize == 0) {
            initialSize = 10;
        }
        this.xValues = new ArrayList(initialSize);
        this.yValues = new ArrayList(initialSize);
        for (int i = 0; i < xValues.length; ++i) {
            this.xValues.add(xValues[i]);
            this.yValues.add(yValues[i]);
        }
    }

    public void addObservation(double x, double y) {
        this.xValues.add(x);
        this.yValues.add(y);
    }

    public void clearObservations() {
        this.xValues.clear();
        this.yValues.clear();
    }

    public UnivariatePolynomialFunction regress() {
        double xTotal = 0.0;
        double yTotal = 0.0;
        double xyTotal = 0.0;
        double xxTotal = 0.0;
        for (int i = 0; i < this.xValues.size(); ++i) {
            double x = this.xValues.get(i);
            double y = this.yValues.get(i);
            xTotal += x;
            yTotal += y;
            xyTotal += x * y;
            xxTotal += x * x;
        }
        double slope = ((double)this.xValues.size() * xyTotal - xTotal * yTotal) / ((double)this.xValues.size() * xxTotal - xTotal * xTotal);
        double intercept = (yTotal - slope * xTotal) / (double)this.xValues.size();
        return new UnivariatePolynomialFunction(slope, intercept);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SimpleLinearRegressor: {\n");
        for (int i = 0; i < this.xValues.size(); ++i) {
            sb.append("\t(" + this.xValues.get(i) + ", " + this.yValues.get(i) + ")\n");
        }
        sb.append("}");
        return sb.toString();
    }
}

