/*
 * Decompiled with CFR 0.152.
 */
package com.robrua.easyjava.ml.optimization.ga;

import com.robrua.easyjava.ml.optimization.ga.AbstractSolutionFactory;
import com.robrua.easyjava.ml.optimization.ga.GeneticAlgorithmSolution;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class GeneticAlgorithmOptimizer<T extends GeneticAlgorithmSolution> {
    private static final double DEFAULT_CROSSOVER_RATE = 0.75;
    private static final double DEFAULT_ELITE_PERCENTAGE = 0.2;
    private static final double DEFAULT_MUTATION_RATE = 0.1;
    private static final int DEFAULT_POPULATION_SIZE = 20;
    private static final SolutionComparator SOLUTION_COMPARATOR = new SolutionComparator();
    private final int eliteCount;
    private final double mutationRate;
    private final double crossoverRate;
    private final List<T> population;

    public GeneticAlgorithmOptimizer(AbstractSolutionFactory<T> factory) {
        this(20, 0.1, 0.75, 0.2, factory);
    }

    public GeneticAlgorithmOptimizer(int populationSize, AbstractSolutionFactory<T> factory) {
        this(populationSize, 0.1, 0.75, 0.2, factory);
    }

    public GeneticAlgorithmOptimizer(int populationSize, double mutationRate, double crossoverRate, double elitePercentage, AbstractSolutionFactory<T> factory) {
        this.population = new ArrayList<T>(populationSize);
        for (int i = 0; i < populationSize; ++i) {
            this.population.add(factory.randomSolution());
        }
        this.rankPopulation();
        this.mutationRate = mutationRate;
        this.crossoverRate = crossoverRate;
        this.eliteCount = (int)(elitePercentage * (double)populationSize);
    }

    public GeneticAlgorithmOptimizer(List<T> population) {
        this(population, 0.1, 0.75, 0.2);
    }

    public GeneticAlgorithmOptimizer(List<T> population, double mutationRate, double crossoverRate, double elitePercentage) {
        this.population = population;
        this.rankPopulation();
        this.mutationRate = mutationRate;
        this.crossoverRate = crossoverRate;
        this.eliteCount = (int)(elitePercentage * (double)population.size());
    }

    private void fillGeneration() {
        List<T> sublist = this.population.subList(this.eliteCount, this.population.size());
        sublist = sublist.parallelStream().map(solution -> {
            GeneticAlgorithmSolution newSol = Math.random() < this.crossoverRate ? this.randomEliteSolution().crossover((GeneticAlgorithmSolution)this.randomEliteSolution()) : this.randomEliteSolution().copy();
            if (Math.random() < this.mutationRate) {
                newSol.mutate();
            }
            return newSol;
        }).collect(Collectors.toList());
        for (int i = this.eliteCount; i < this.population.size(); ++i) {
            this.population.set(i, sublist.get(i - this.eliteCount));
        }
    }

    public void nextGeneration() {
        this.fillGeneration();
        this.rankPopulation();
    }

    public List<T> population() {
        return Collections.unmodifiableList(this.population);
    }

    private T randomEliteSolution() {
        return (T)((GeneticAlgorithmSolution)this.population.get((int)(Math.random() * (double)this.eliteCount)));
    }

    private void rankPopulation() {
        Collections.sort(this.population, SOLUTION_COMPARATOR);
    }

    public void runFor(int generations) {
        for (int i = 0; i < generations; ++i) {
            this.nextGeneration();
        }
    }

    private static class SolutionComparator
    implements Comparator<GeneticAlgorithmSolution> {
        private SolutionComparator() {
        }

        @Override
        public int compare(GeneticAlgorithmSolution arg0, GeneticAlgorithmSolution arg1) {
            long diff = arg1.fitness() - arg0.fitness();
            if (diff > 0L) {
                return 1;
            }
            if (diff < 0L) {
                return -1;
            }
            return 0;
        }
    }
}

