/*
 * Decompiled with CFR 0.152.
 */
package com.robrua.easyjava.net.rest;

import com.robrua.easyjava.net.rest.RateLimiter;
import com.robrua.easyjava.net.rest.SingleRateLimiter;
import com.robrua.easyjava.type.Pair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;

public class MultiRateLimiter
implements RateLimiter {
    private final List<SingleRateLimiter> limiters;

    public MultiRateLimiter(RateLimiter.Type type, List<Pair<Integer, Long>> limits) {
        this.limiters = new ArrayList<SingleRateLimiter>(limits.size());
        limits.forEach(limit -> this.limiters.add(new SingleRateLimiter(type, (Integer)limit.getLeft(), (Long)limit.getRight())));
    }

    @Override
    public synchronized <T> T attemptCall(Supplier<T> call) {
        if (this.numCallsLeft() >= 1) {
            T retVal = call.get();
            this.limiters.parallelStream().forEach(limiter -> limiter.attemptCall(() -> null));
            return retVal;
        }
        return null;
    }

    @Override
    public synchronized long millisUntilNextCall() {
        return this.limiters.parallelStream().map(limiter -> limiter.millisUntilNextCall()).max(Comparator.naturalOrder()).get();
    }

    @Override
    public synchronized int numCallsLeft() {
        return this.limiters.parallelStream().map(limiter -> limiter.numCallsLeft()).min(Comparator.naturalOrder()).get();
    }

    @Override
    public synchronized <T> T waitForCall(Supplier<T> call) throws InterruptedException {
        T retVal = this.attemptCall(call);
        if (retVal == null) {
            Thread.sleep(this.millisUntilNextCall());
            retVal = this.attemptCall(call);
        }
        return retVal;
    }
}

