/*
 * Decompiled with CFR 0.152.
 */
package com.robrua.easyjava.net.rest;

import com.robrua.easyjava.net.rest.NotFoundException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;

public class SimpleRESTClient {
    private String URL;
    private final String userAgent;

    public static String deleteAt(String URL2) throws IOException {
        return new SimpleRESTClient(URL2).delete();
    }

    public static String getFrom(String URL2) throws IOException {
        return SimpleRESTClient.getFrom(URL2, null);
    }

    public static String getFrom(String URL2, Map<String, String> parameters) throws IOException {
        return new SimpleRESTClient(URL2).get(parameters);
    }

    public static String postTo(String URL2, String postContent) throws IOException {
        return SimpleRESTClient.postTo(URL2, "text/plain", postContent);
    }

    public static String postTo(String URL2, String contentType, String postContent) throws IOException {
        return new SimpleRESTClient(URL2).post(contentType, postContent);
    }

    public static String putTo(String URL2, String putContent) throws IOException {
        return SimpleRESTClient.putTo(URL2, "text/pain", putContent);
    }

    public static String putTo(String URL2, String contentType, String putContent) throws IOException {
        return new SimpleRESTClient(URL2).put(contentType, putContent);
    }

    public SimpleRESTClient(String URL2) {
        this(URL2, "EasyJava");
    }

    public SimpleRESTClient(String URL2, String userAgent) {
        this.URL = URL2.contains("://") ? URL2 : "http://" + URL2;
        if (!URL2.endsWith("/")) {
            this.URL = this.URL + "/";
        }
        this.userAgent = userAgent == null ? "" : userAgent;
    }

    public String delete() throws IOException {
        return this.delete("");
    }

    public String delete(String URI2) throws IOException {
        String line;
        if (URI2.startsWith("/")) {
            URI2 = URI2.substring(1);
        }
        URL url = new URL(this.URL + URI2);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("DELETE");
        if (!this.userAgent.isEmpty()) {
            connection.setRequestProperty("User-Agent", this.userAgent);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        StringBuilder sb = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            sb.append(line + "\n");
        }
        reader.close();
        connection.disconnect();
        return sb.toString();
    }

    public String get() throws IOException {
        return this.get("");
    }

    public String get(Map<String, String> parameters) throws IOException {
        return this.get("", parameters);
    }

    public String get(String URI2) throws IOException {
        return this.get(URI2, null);
    }

    public String get(String URI2, Map<String, String> parameters) throws IOException {
        String line;
        BufferedReader reader;
        if (URI2.startsWith("/")) {
            URI2 = URI2.substring(1);
        }
        String params = "";
        if (parameters != null && parameters.size() > 0) {
            for (String key : parameters.keySet()) {
                params = params + "&" + URLEncoder.encode(key, "UTF-8") + "=" + URLEncoder.encode(parameters.get(key), "UTF-8");
            }
            params = "?" + params.substring(1);
        }
        URL url = new URL(this.URL + URI2 + params);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        if (!this.userAgent.isEmpty()) {
            connection.setRequestProperty("User-Agent", this.userAgent);
        }
        try {
            reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        }
        catch (FileNotFoundException e) {
            throw new NotFoundException("Server returned HTTP response code: 404 for URL " + e.getMessage());
        }
        StringBuilder sb = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            sb.append(line + "\n");
        }
        reader.close();
        connection.disconnect();
        return sb.toString();
    }

    public String post(String postContent) throws IOException {
        return this.post("text/plain", postContent);
    }

    public String post(String contentType, String postContent) throws IOException {
        return this.post("", contentType, postContent);
    }

    public String post(String URI2, String contentType, String postContent) throws IOException {
        String line;
        if (URI2.startsWith("/")) {
            URI2 = URI2.substring(1);
        }
        URL url = new URL(this.URL + URI2);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", contentType);
        if (!this.userAgent.isEmpty()) {
            connection.setRequestProperty("User-Agent", this.userAgent);
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream()));
        writer.write(postContent);
        writer.close();
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        StringBuilder sb = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            sb.append(line + "\n");
        }
        reader.close();
        connection.disconnect();
        return sb.toString();
    }

    public String put(String putContent) throws IOException {
        return this.put("text/plain", putContent);
    }

    public String put(String contentType, String putContent) throws IOException {
        return this.put("", contentType, putContent);
    }

    public String put(String URI2, String contentType, String putContent) throws IOException {
        String line;
        if (URI2.startsWith("/")) {
            URI2 = URI2.substring(1);
        }
        URL url = new URL(this.URL + URI2);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("PUT");
        connection.setRequestProperty("Content-Type", contentType);
        if (!this.userAgent.isEmpty()) {
            connection.setRequestProperty("User-Agent", this.userAgent);
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream()));
        writer.write(putContent);
        writer.close();
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        StringBuilder sb = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            sb.append(line + "\n");
        }
        reader.close();
        connection.disconnect();
        return sb.toString();
    }

    public String toString() {
        return "SimpleRestClient(" + this.URL + ")";
    }
}

