/*
 * Decompiled with CFR 0.152.
 */
package com.robrua.easyjava.net.rest;

import com.robrua.easyjava.net.rest.RateLimiter;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.function.Supplier;

public class SingleRateLimiter
implements RateLimiter {
    private double callsLeft;
    private LocalDateTime check;
    private final double limit;
    private final double callsPerMilli;
    private final double millisPerCall;
    private final long millisPerEpoch;
    private final RateLimiter.Type type;

    public SingleRateLimiter(RateLimiter.Type type, int callsPerEpoch, long millisPerEpoch) {
        this.millisPerEpoch = millisPerEpoch;
        this.type = type;
        this.limit = callsPerEpoch;
        if (type == RateLimiter.Type.ROLLING) {
            this.callsPerMilli = (double)callsPerEpoch / (double)millisPerEpoch;
            this.millisPerCall = 1.0 / this.callsPerMilli;
        } else {
            this.callsPerMilli = 0.0;
            this.millisPerCall = 0.0;
        }
        this.callsLeft = this.limit;
        this.check = LocalDateTime.now();
    }

    @Override
    public synchronized <T> T attemptCall(Supplier<T> call) {
        this.updateCallsLeft();
        T retVal = null;
        if (this.callsLeft == this.limit) {
            this.callsLeft -= 1.0;
            retVal = call.get();
            this.check = LocalDateTime.now();
        } else if (this.callsLeft >= 1.0) {
            this.callsLeft -= 1.0;
            retVal = call.get();
        }
        return retVal;
    }

    @Override
    public synchronized long millisUntilNextCall() {
        this.updateCallsLeft();
        if (this.callsLeft >= 1.0) {
            return 0L;
        }
        long millisUntilNextCall = 0L;
        if (this.type == RateLimiter.Type.WINDOW) {
            long millisPassed = Duration.between(this.check, LocalDateTime.now()).toMillis();
            millisUntilNextCall = this.millisPerEpoch - millisPassed;
        } else if (this.type == RateLimiter.Type.ROLLING) {
            millisUntilNextCall = (long)Math.ceil((1.0 - this.callsLeft) * this.millisPerCall);
        }
        return millisUntilNextCall;
    }

    @Override
    public synchronized int numCallsLeft() {
        this.updateCallsLeft();
        return (int)this.callsLeft;
    }

    private void updateCallsLeft() {
        long millisPassed = Duration.between(this.check, LocalDateTime.now()).toMillis();
        if (this.type == RateLimiter.Type.ROLLING) {
            this.callsLeft += this.callsPerMilli * (double)millisPassed;
            if (this.callsLeft > this.limit) {
                this.callsLeft = this.limit;
            }
            this.check = LocalDateTime.now();
        } else if (this.type == RateLimiter.Type.WINDOW && millisPassed >= this.millisPerEpoch) {
            this.callsLeft = this.limit;
            this.check = LocalDateTime.now();
        }
    }

    @Override
    public synchronized <T> T waitForCall(Supplier<T> call) throws InterruptedException {
        T retVal = this.attemptCall(call);
        if (retVal == null) {
            Thread.sleep(this.millisUntilNextCall());
            retVal = this.attemptCall(call);
        }
        return retVal;
    }
}

