/*
 * Decompiled with CFR 0.152.
 */
package com.robrua.easyjava.net.rmi;

import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.RemoteServer;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.UnicastRemoteObject;

public abstract class ExportedObject
extends UnicastRemoteObject
implements Remote {
    private static final long serialVersionUID = -6247820314862243451L;
    private final String remoteName;

    public ExportedObject(String remoteName) throws RemoteException, MalformedURLException {
        this(null, remoteName);
    }

    public ExportedObject(String hostName, String remoteName) throws RemoteException, MalformedURLException {
        super(0);
        if (hostName != null) {
            System.setProperty("java.rmi.server.hostname", hostName);
        }
        try {
            LocateRegistry.createRegistry(1099);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this.remoteName = remoteName;
        Naming.rebind(remoteName, this);
    }

    public void close() {
        try {
            UnicastRemoteObject.unexportObject(this, true);
            Naming.unbind(this.remoteName);
        }
        catch (MalformedURLException | NotBoundException | RemoteException exception) {
            // empty catch block
        }
    }

    protected String getCallerIP() {
        try {
            return RemoteServer.getClientHost();
        }
        catch (ServerNotActiveException e) {
            return null;
        }
    }
}

