/*
 * Decompiled with CFR 0.152.
 */
package com.robrua.easyjava.net.tcp;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class Connection<S extends Serializable, R extends Serializable> {
    private boolean closed;
    private final Lock lock;
    private final BlockingQueue<R> queue;
    private final ObjectInputStream reader;
    private final Class<R> receivingClass;
    private final Socket socket;
    private ConnectionStatus status;
    private final ObjectOutputStream writer;

    public Connection(Socket socket) throws IOException {
        this(socket, null);
    }

    public Connection(Socket socket, Class<R> receivingClass) throws IOException {
        this.receivingClass = receivingClass;
        this.socket = socket;
        this.closed = false;
        this.writer = new ObjectOutputStream(socket.getOutputStream());
        this.reader = new ObjectInputStream(socket.getInputStream());
        this.queue = new LinkedBlockingQueue<R>();
        this.status = ConnectionStatus.OPEN;
        this.lock = new Lock();
        new Thread(new SocketReader(this)).start();
    }

    public Connection(String host, int port) throws IOException {
        this(new Socket(host, port));
    }

    public Connection(String host, int port, Class<R> receivingClass) throws IOException {
        this(new Socket(host, port), receivingClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.status != ConnectionStatus.CLOSED) {
            try {
                this.writer.writeObject((Object)ConnectionStatus.CLOSED);
                this.writer.flush();
            }
            catch (IOException e) {
                // empty catch block
            }
            this.status = ConnectionStatus.CLOSED;
        }
        try {
            this.writer.close();
            this.reader.close();
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!this.closed) {
            this.queue.add("");
            this.closed = true;
        }
        Lock lock = this.lock;
        synchronized (lock) {
            this.lock.notifyAll();
        }
    }

    public boolean isClosed() {
        return this.status == ConnectionStatus.CLOSED;
    }

    public R receive() throws InterruptedException {
        Serializable item = (Serializable)this.queue.take();
        if (this.status == ConnectionStatus.CLOSED && this.queue.isEmpty()) {
            this.queue.add(item);
            return null;
        }
        return (R)item;
    }

    public R receive(long timeout, TimeUnit unit) throws InterruptedException {
        Serializable item = (Serializable)this.queue.poll(timeout, unit);
        if (this.closed && this.queue.isEmpty()) {
            this.queue.add(item);
            return null;
        }
        return (R)item;
    }

    public boolean receiveWillBlock() {
        return this.queue.isEmpty();
    }

    public boolean send(S message) throws IOException {
        if (this.status != ConnectionStatus.CLOSED) {
            this.writer.writeObject(message);
            this.writer.flush();
            return true;
        }
        return false;
    }

    public String toString() {
        return "Connection(" + this.socket.getRemoteSocketAddress() + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForEvent() throws InterruptedException {
        Lock lock = this.lock;
        synchronized (lock) {
            this.lock.wait();
        }
    }

    private static final class SocketReader<S extends Serializable, R extends Serializable>
    implements Runnable {
        private final Connection<S, R> owner;

        public SocketReader(Connection<S, R> owner) {
            this.owner = owner;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (((Connection)this.owner).status != ConnectionStatus.CLOSED) {
                try {
                    Object object = ((Connection)this.owner).reader.readObject();
                    if (object instanceof ConnectionStatus) {
                        ((Connection)this.owner).status = (ConnectionStatus)((Object)object);
                        continue;
                    }
                    Serializable item = ((Connection)this.owner).receivingClass != null ? (Serializable)((Connection)this.owner).receivingClass.cast(object) : (Serializable)object;
                    ((Connection)this.owner).queue.add(item);
                    Lock lock = ((Connection)this.owner).lock;
                    synchronized (lock) {
                        ((Connection)this.owner).lock.notifyAll();
                    }
                }
                catch (SocketException e) {
                    ((Connection)this.owner).status = ConnectionStatus.CLOSED;
                }
                catch (IOException | ClassCastException | ClassNotFoundException exception) {
                }
            }
            this.owner.close();
        }
    }

    private static final class Lock {
        private Lock() {
        }
    }

    private static enum ConnectionStatus {
        CLOSED,
        OPEN;

    }
}

