/*
 * Decompiled with CFR 0.152.
 */
package com.robrua.easyjava.net.tcp;

import com.robrua.easyjava.net.tcp.Connection;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;

public class ConnectionPool<S extends Serializable, R extends Serializable>
implements Set<Connection<S, R>> {
    private final Map<Connection<S, R>, ConnectionMonitor<S, R>> connections = new ConcurrentHashMap<Connection<S, R>, ConnectionMonitor<S, R>>();
    private final BlockingQueue<Connection<S, R>> notified = new LinkedBlockingQueue<Connection<S, R>>();

    @Override
    public boolean add(Connection<S, R> arg0) {
        if (this.connections.containsKey(arg0)) {
            return false;
        }
        ConnectionMonitor<S, R> cm = new ConnectionMonitor<S, R>(this, arg0);
        new Thread(cm).start();
        this.connections.put(arg0, cm);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Connection<S, R>> arg0) {
        boolean changed = false;
        for (Connection<S, R> conn : arg0) {
            changed &= this.add(conn);
        }
        return changed;
    }

    @Override
    public void clear() {
        this.connections.clear();
    }

    @Override
    public boolean contains(Object arg0) {
        return this.connections.containsKey(arg0);
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        return this.connections.keySet().containsAll(arg0);
    }

    @Override
    public boolean isEmpty() {
        return this.connections.isEmpty();
    }

    @Override
    public Iterator<Connection<S, R>> iterator() {
        return this.connections.keySet().iterator();
    }

    @Override
    public boolean remove(Object arg0) {
        if (!this.connections.containsKey(arg0)) {
            return false;
        }
        this.connections.get(arg0).stop();
        this.connections.remove(arg0);
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        boolean changed = false;
        for (Object obj : arg0) {
            changed &= this.remove(obj);
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        boolean changed = false;
        for (Connection<S, R> conn : this.connections.keySet()) {
            if (arg0.contains(conn)) continue;
            changed &= this.remove(conn);
        }
        return changed;
    }

    @Override
    public int size() {
        return this.connections.size();
    }

    @Override
    public Object[] toArray() {
        return this.connections.keySet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] arg0) {
        return this.connections.keySet().toArray(arg0);
    }

    public Connection<S, R> waitForEvent() throws InterruptedException {
        return this.notified.take();
    }

    private static final class ConnectionMonitor<S extends Serializable, R extends Serializable>
    implements Runnable {
        private final Connection<S, R> connection;
        private final ConnectionPool<S, R> owner;
        private Thread thread;

        public ConnectionMonitor(ConnectionPool<S, R> owner, Connection<S, R> connection) {
            this.owner = owner;
            this.connection = connection;
        }

        @Override
        public void run() {
            this.thread = Thread.currentThread();
            while (!this.thread.isInterrupted()) {
                try {
                    this.connection.waitForEvent();
                }
                catch (InterruptedException e) {
                    break;
                }
                ((ConnectionPool)this.owner).notified.offer(this.connection);
            }
        }

        public void stop() {
            this.thread.interrupt();
        }
    }
}

