/*
 * Decompiled with CFR 0.152.
 */
package com.robrua.easyjava.net.tcp;

import com.robrua.easyjava.io.output.Logger;
import com.robrua.easyjava.net.tcp.BroadcastException;
import com.robrua.easyjava.net.tcp.Connection;
import com.robrua.easyjava.net.tcp.ConnectionPool;
import java.io.IOException;
import java.io.Serializable;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class TCPServer<S extends Serializable, R extends Serializable> {
    private Server<S, R> server;

    public TCPServer(int port) throws IOException {
        this(port, null, Logger.nullLogger());
    }

    public TCPServer(int port, Class<R> receivingClass) throws IOException {
        this(port, receivingClass, Logger.nullLogger());
    }

    public TCPServer(int port, Class<R> receivingClass, Logger logger) throws IOException {
        this.server = new Server(this, port, receivingClass, logger);
        new Thread(this.server).start();
    }

    public TCPServer(int port, Logger logger) throws IOException {
        this(port, null, logger);
    }

    public void broadcast(S message) throws BroadcastException {
        this.server.broadcast(message);
    }

    protected abstract void closedConnectionHandle(Connection<S, R> var1);

    public Set<Connection<S, R>> getConnections() {
        return this.server.getConnections();
    }

    protected abstract void newConnectionHandle(Connection<S, R> var1);

    protected abstract void receiveHandle(R var1, Connection<S, R> var2);

    public void stop() {
        this.server.stop();
    }

    private static class Server<S extends Serializable, R extends Serializable>
    implements Runnable {
        private final ConnectionPool<S, R> connections;
        private final Logger logger;
        private final NewConnectionMonitor newConns;
        private final TCPServer<S, R> owner;
        private final Class<R> receivingClass;
        private boolean stopped;

        public Server(TCPServer<S, R> owner, int port, Class<R> receivingClass, Logger logger) throws IOException {
            this.owner = owner;
            this.receivingClass = receivingClass;
            this.logger = logger;
            this.connections = new ConnectionPool();
            this.newConns = new NewConnectionMonitor(this, port);
            this.stopped = false;
        }

        private void addConnection(Socket socket) throws IOException {
            Connection conn = this.receivingClass != null ? new Connection(socket, this.receivingClass) : new Connection(socket);
            new Thread(new NewConnectionHandler(conn)).start();
        }

        public void broadcast(S message) throws BroadcastException {
            HashSet<IOException> exceptions = new HashSet<IOException>();
            this.connections.forEach(conn -> {
                try {
                    conn.send(message);
                }
                catch (IOException e) {
                    exceptions.add(e);
                }
            });
            if (exceptions.size() > 0) {
                throw new BroadcastException(exceptions);
            }
        }

        public Set<Connection<S, R>> getConnections() {
            return Collections.unmodifiableSet(this.connections);
        }

        @Override
        public void run() {
            new Thread(this.newConns).start();
            while (!this.stopped) {
                try {
                    Connection<S, R> conn2 = this.connections.waitForEvent();
                    if (conn2.isClosed()) {
                        new Thread(new ClosedConnectionHandler(conn2)).start();
                        continue;
                    }
                    if (conn2.receiveWillBlock()) continue;
                    try {
                        new Thread(new ReceiveHandler(this, conn2.receive(), conn2)).start();
                    }
                    catch (InterruptedException e) {
                        this.logger.warn(e);
                    }
                }
                catch (InterruptedException e1) {
                    this.logger.warn(e1);
                }
            }
            this.connections.forEach(conn -> conn.close());
        }

        public void stop() {
            this.stopped = true;
            this.newConns.stop();
        }

        private static class ReceiveHandler
        implements Runnable {
            private final Connection<S, R> connection;
            private final R received;
            final /* synthetic */ Server this$0;

            public ReceiveHandler(R received, Connection<S, R> connection) {
                this.this$0 = var1_1;
                this.received = received;
                this.connection = connection;
            }

            @Override
            public void run() {
                this.this$0.owner.receiveHandle(this.received, this.connection);
            }
        }

        private static class NewConnectionMonitor
        implements Runnable {
            private final Server<?, ?> owner;
            private final ServerSocket socket;
            private boolean stopped;

            public NewConnectionMonitor(Server<?, ?> owner, int port) throws IOException {
                this.owner = owner;
                this.socket = new ServerSocket(port);
                this.stopped = false;
            }

            @Override
            public void run() {
                try {
                    this.socket.setSoTimeout(500);
                }
                catch (SocketException e1) {
                    ((Server)this.owner).logger.error(e1);
                }
                while (!this.stopped) {
                    try {
                        ((Server)this.owner).addConnection(this.socket.accept());
                    }
                    catch (SocketTimeoutException e) {
                    }
                    catch (IOException e) {
                        ((Server)this.owner).logger.error(e);
                    }
                }
                try {
                    this.socket.close();
                }
                catch (IOException e) {
                    ((Server)this.owner).logger.error(e);
                }
            }

            public void stop() {
                this.stopped = true;
            }
        }

        private class NewConnectionHandler
        implements Runnable {
            private final Connection<S, R> newConnection;

            public NewConnectionHandler(Connection<S, R> newConnection) {
                this.newConnection = newConnection;
            }

            @Override
            public void run() {
                Server.this.owner.newConnectionHandle(this.newConnection);
                Server.this.connections.add(this.newConnection);
            }
        }

        private class ClosedConnectionHandler
        implements Runnable {
            private final Connection<S, R> conn;

            public ClosedConnectionHandler(Connection<S, R> conn) {
                this.conn = conn;
            }

            @Override
            public void run() {
                Server.this.connections.remove(this.conn);
                Server.this.owner.closedConnectionHandle(this.conn);
            }
        }
    }
}

