/*
 * Decompiled with CFR 0.152.
 */
package com.robrua.easyjava.net.udp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.util.Arrays;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class UDPListener<R extends Serializable> {
    private static final int MAX_UDP_BYTES = 65507;
    private boolean closed;
    private final BlockingQueue<UDPMessage<R>> queue;
    private final Class<R> receivingClass;
    private final DatagramSocket socket;

    public UDPListener(int port) throws SocketException {
        this(port, null);
    }

    public UDPListener(int port, Class<R> receivingClass) throws SocketException {
        this.socket = new DatagramSocket(port);
        this.queue = new LinkedBlockingQueue<UDPMessage<R>>();
        this.closed = false;
        this.receivingClass = receivingClass;
        new Thread(new SocketReader(this)).start();
    }

    public void close() {
        if (!this.closed) {
            this.queue.add(new UDPMessage<Object>(null, "", -1));
            this.closed = true;
            this.socket.close();
        }
    }

    public UDPMessage<R> receive() throws InterruptedException {
        UDPMessage<R> item = this.queue.take();
        if (this.closed && this.queue.isEmpty()) {
            this.queue.add(item);
            return null;
        }
        return item;
    }

    public UDPMessage<R> receive(long timeout, TimeUnit unit) throws InterruptedException {
        UDPMessage<R> item = this.queue.poll(timeout, unit);
        if (this.closed && this.queue.isEmpty()) {
            this.queue.add(item);
            return null;
        }
        return item;
    }

    public boolean receiveWillBlock() {
        return this.queue.isEmpty();
    }

    public static final class UDPMessage<R extends Serializable> {
        public final R data;
        public final String sourceIP;
        public final int sourcePort;

        public UDPMessage(R data, String sourceIP, int sourcePort) {
            this.data = data;
            this.sourceIP = sourceIP;
            this.sourcePort = sourcePort;
        }
    }

    private static final class SocketReader<R extends Serializable>
    implements Runnable {
        private final UDPListener<R> owner;

        public SocketReader(UDPListener<R> owner) {
            this.owner = owner;
        }

        private R deserialize(byte[] bytes) throws IOException, ClassNotFoundException {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bais);
            Object object = ois.readObject();
            ois.close();
            bais.close();
            Serializable data = ((UDPListener)this.owner).receivingClass != null ? (Serializable)((UDPListener)this.owner).receivingClass.cast(object) : (Serializable)object;
            return (R)data;
        }

        @Override
        public void run() {
            byte[] data = new byte[65507];
            while (!((UDPListener)this.owner).closed) {
                try {
                    DatagramPacket packet = new DatagramPacket(data, data.length);
                    ((UDPListener)this.owner).socket.receive(packet);
                    byte[] bytes = Arrays.copyOf(packet.getData(), packet.getLength());
                    R item = this.deserialize(bytes);
                    ((UDPListener)this.owner).queue.add(new UDPMessage<R>(item, packet.getAddress().getHostAddress(), packet.getPort()));
                }
                catch (IOException | ClassNotFoundException exception) {}
            }
        }
    }
}

