/*
 * Decompiled with CFR 0.152.
 */
package com.robrua.easyjava.net.udp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

public class UDPSender<S extends Serializable> {
    private static volatile int numOpen;
    private static DatagramSocket socket;
    private final InetAddress address;
    private final int port;

    private static synchronized void initializeSocket() throws SocketException {
        if (socket == null || socket.isClosed()) {
            socket = new DatagramSocket();
        }
    }

    public UDPSender(String IPAddress, int port) throws UnknownHostException, SocketException {
        this.address = InetAddress.getByName(IPAddress);
        this.port = port;
        UDPSender.initializeSocket();
        ++numOpen;
    }

    public void close() {
        if (--numOpen == 0) {
            socket.close();
        }
    }

    public void send(S data) throws IOException {
        byte[] bytes = this.serialize(data);
        DatagramPacket packet = new DatagramPacket(bytes, bytes.length, this.address, this.port);
        socket.send(packet);
    }

    private byte[] serialize(S data) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(data);
        oos.close();
        byte[] serial = baos.toByteArray();
        baos.close();
        return serial;
    }
}

