/*
 * Decompiled with CFR 0.152.
 */
package com.robrua.easyjava.type;

import com.robrua.easyjava.type.MultiMap;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ListMultiMap<K, V>
implements MultiMap<K, V> {
    private static final long serialVersionUID = -2244351300048341475L;
    private final Map<K, List<V>> map = new HashMap<K, List<V>>();

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        for (K key : this.map.keySet()) {
            if (!this.map.get(key).contains(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<Map.Entry<K, V>> entries() {
        LinkedList<Map.Entry<K, V>> entries = new LinkedList<Map.Entry<K, V>>();
        for (K key : this.map.keySet()) {
            for (V val : this.map.get(key)) {
                entries.add(new AbstractMap.SimpleImmutableEntry<K, V>(key, val));
            }
        }
        return entries;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMultiMap)) {
            return false;
        }
        ListMultiMap other = (ListMultiMap)obj;
        return !(this.map == null ? other.map != null : !this.map.equals(other.map));
    }

    @Override
    public List<V> get(Object key) {
        return this.map.get(key);
    }

    @Override
    public List<V> getEmptyCollection() {
        return new LinkedList();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.map == null ? 0 : this.map.hashCode());
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public void put(K key, Collection<V> values) {
        if (!this.map.containsKey(key)) {
            LinkedList val = new LinkedList();
            this.map.put(key, val);
        }
        this.map.get(key).addAll(values);
    }

    @Override
    public void put(K key, V value) {
        if (!this.map.containsKey(key)) {
            ArrayList val = new ArrayList();
            this.map.put(key, val);
        }
        this.map.get(key).add(value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void putAll(MultiMap<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entries()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public List<V> remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public int size() {
        int count = 0;
        for (K key : this.map.keySet()) {
            count += this.map.get(key).size();
        }
        return count;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (K key : this.map.keySet()) {
            sb.append("\n\t" + key.toString() + ": ");
            String vals = "";
            for (V val : this.map.get(key)) {
                vals = vals + ", " + val.toString();
            }
            sb.append(vals.substring(2));
        }
        sb.append("\n}");
        return sb.toString();
    }

    @Override
    public Collection<V> values() {
        LinkedList values = new LinkedList();
        for (K key : this.map.keySet()) {
            values.addAll(this.map.get(key));
        }
        return values;
    }
}

