/*
 * Decompiled with CFR 0.152.
 */
package com.robrua.easyjava.type;

import com.robrua.easyjava.type.Pair;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

public interface MultiMap<K, V>
extends Serializable {
    public void clear();

    default public Collection<V> compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        Collection<V> oldValues = this.get(key);
        if (oldValues != null) {
            Collection newValues = oldValues.parallelStream().map(value -> {
                Object retVal = remappingFunction.apply(key, value);
                return retVal;
            }).collect(Collectors.toCollection(() -> this.getEmptyCollection()));
            if (newValues.size() > 0) {
                this.remove(key);
                this.put(key, (V)newValues);
            } else {
                this.remove(key);
            }
            return newValues;
        }
        V newValue = remappingFunction.apply(key, null);
        if (newValue != null) {
            this.put(key, newValue);
            return this.get(key);
        }
        return null;
    }

    default public Collection<V> computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        V newValue;
        if (this.get(key) == null && (newValue = mappingFunction.apply(key)) != null) {
            this.put(key, newValue);
        }
        return this.get(key);
    }

    default public Collection<V> computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        Collection<V> oldValues = this.get(key);
        if (oldValues != null) {
            Collection newValues = oldValues.parallelStream().map(value -> {
                Object retVal = remappingFunction.apply((Object)key, (Object)value);
                return retVal;
            }).collect(Collectors.toCollection(() -> this.getEmptyCollection()));
            if (newValues.size() > 0) {
                this.remove(key);
                this.put(key, (V)newValues);
            } else {
                this.remove(key);
            }
        }
        return this.get(key);
    }

    public boolean containsKey(Object var1);

    public boolean containsValue(Object var1);

    public Collection<Map.Entry<K, V>> entries();

    default public void forEach(BiConsumer<? super K, ? super V> action) {
        this.entries().stream().forEach((? super T entry) -> action.accept((Object)entry.getKey(), (Object)entry.getValue()));
    }

    public Collection<V> get(Object var1);

    public Collection<V> getEmptyCollection();

    default public Collection<V> getOrDefault(Object key, Collection<V> defaultValues) {
        Collection<V> retVal = this.get(key);
        if (retVal != null) {
            return retVal;
        }
        return defaultValues;
    }

    public boolean isEmpty();

    public Set<K> keySet();

    default public Collection<V> merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        Collection<V> oldValues = this.get(key);
        if (oldValues == null && value != null) {
            this.put(key, value);
        } else {
            Collection newValues = oldValues.parallelStream().map(oldValue -> {
                Object retVal = remappingFunction.apply((Object)oldValue, (Object)value);
                return retVal;
            }).collect(Collectors.toCollection(() -> this.getEmptyCollection()));
            if (newValues.size() > 0) {
                this.remove(key);
                this.put(key, (V)newValues);
            } else {
                this.remove(key);
            }
        }
        return this.get(key);
    }

    public void put(K var1, Collection<V> var2);

    public void put(K var1, V var2);

    public void putAll(Map<? extends K, ? extends V> var1);

    public void putAll(MultiMap<? extends K, ? extends V> var1);

    default public void putIfAbsent(K key, Collection<V> values) {
        if (this.get(key) == null) {
            this.put(key, (V)values);
        }
    }

    default public void putIfAbsent(K key, V value) {
        if (this.get(key) == null) {
            this.put(key, value);
        }
    }

    public Collection<V> remove(Object var1);

    default public boolean remove(Object key, Collection<Object> values) {
        Collection<V> oldValues = this.get(key);
        if (oldValues != null && oldValues.equals(values)) {
            this.remove(key);
            return true;
        }
        return false;
    }

    default public Collection<V> replace(K key, Collection<V> values) {
        if (this.containsKey(key)) {
            Collection<V> oldVals = this.remove(key);
            this.put(key, (V)values);
            return oldVals;
        }
        return null;
    }

    default public boolean replace(K key, Collection<V> oldValues, Collection<V> newValues) {
        Collection<V> currentValues = this.get(key);
        if (currentValues != null && currentValues.equals(oldValues)) {
            this.remove(key);
            this.put(key, (V)newValues);
            return true;
        }
        return false;
    }

    default public Collection<V> replace(K key, V value) {
        if (this.containsKey(key)) {
            Collection<V> oldVals = this.remove(key);
            this.put(key, value);
            return oldVals;
        }
        return null;
    }

    default public boolean replace(K key, V oldValue, V newValue) {
        Collection<V> oldValues = this.get(key);
        if (oldValues != null && oldValues.contains(oldValue)) {
            oldValues.remove(oldValue);
            oldValues.add(newValue);
            this.remove(key);
            this.put(key, (V)oldValues);
            return true;
        }
        return false;
    }

    default public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        List newEntries = this.entries().stream().map(entry -> new Pair(entry.getKey(), function.apply((Object)entry.getKey(), (Object)entry.getValue()))).collect(Collectors.toList());
        this.clear();
        newEntries.stream().forEach((? super T pair) -> this.put(pair.getKey(), pair.getValue()));
    }

    public int size();

    public Collection<V> values();
}

