/*
 * Decompiled with CFR 0.152.
 */
package com.robrua.easyjava.type;

import java.io.Serializable;
import java.util.Map;

public class Pair<T1, T2>
implements Map.Entry<T1, T2>,
Comparable<Pair<T1, T2>>,
Serializable {
    private static final long serialVersionUID = -2101769994345848538L;
    private T1 left;
    private T2 right;

    public Pair(T1 left, T2 right) {
        this.left = left;
        this.right = right;
    }

    @Override
    public int compareTo(Pair<T1, T2> other) {
        int leftCompare;
        if (this.left instanceof Comparable && (leftCompare = ((Comparable)this.left).compareTo(other.left)) != 0) {
            return leftCompare;
        }
        if (this.right instanceof Comparable) {
            int rightCompare = ((Comparable)this.right).compareTo(other.right);
            return rightCompare;
        }
        throw new UnsupportedOperationException("Cant compare a pair with two non-comparable components");
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Pair)) {
            return false;
        }
        Pair other = (Pair)obj;
        if (this.left == null ? other.left != null : !this.left.equals(other.left)) {
            return false;
        }
        return !(this.right == null ? other.right != null : !this.right.equals(other.right));
    }

    @Override
    public T1 getKey() {
        return this.left;
    }

    public T1 getLeft() {
        return this.left;
    }

    public T2 getRight() {
        return this.right;
    }

    @Override
    public T2 getValue() {
        return this.right;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.left == null ? 0 : this.left.hashCode());
        result = 31 * result + (this.right == null ? 0 : this.right.hashCode());
        return result;
    }

    public void setKey(T1 key) {
        this.left = key;
    }

    public void setLeft(T1 left) {
        this.left = left;
    }

    public void setRight(T2 right) {
        this.right = right;
    }

    @Override
    public T2 setValue(T2 value) {
        T2 old = this.right;
        this.right = value;
        return old;
    }

    public String toString() {
        return "(" + this.left.toString() + ", " + this.right.toString() + ")";
    }
}

