/*
 * Decompiled with CFR 0.152.
 */
package com.robrua.easyjava.type.primitive;

import java.io.Serializable;
import java.util.Arrays;

public class DoubleArrayList
implements Serializable {
    private static final long serialVersionUID = -6315335197735506416L;
    private double[] list;
    private int size;

    public DoubleArrayList() {
        this(10);
    }

    public DoubleArrayList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Initial capacity must be non-negative");
        }
        this.list = new double[initialCapacity];
        this.size = 0;
    }

    public void add(double v) {
        this.add(this.size, v);
    }

    public void add(int index, double v) {
        if (index >= this.size || index < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.size == this.list.length) {
            this.doubleCapacity(1);
        }
        for (int i = this.size; i > index; --i) {
            this.list[i] = this.list[i - 1];
        }
        this.list[index] = v;
        ++this.size;
    }

    public void clear() {
        this.list = new double[this.list.length];
        this.size = 0;
    }

    public boolean contains(double v) {
        return this.indexOf(v) >= 0;
    }

    private void doubleCapacity(int times) {
        double[] newList = new double[this.list.length * (int)Math.pow(2.0, times)];
        for (int i = 0; i < this.list.length; ++i) {
            newList[i] = this.list[i];
        }
        this.list = newList;
    }

    public void ensureCapacity(double minCapacity) {
        if (minCapacity > (double)this.list.length) {
            int doubleTimes = (int)Math.ceil(Math.log(minCapacity / (double)this.list.length) / Math.log(2.0));
            this.doubleCapacity(doubleTimes);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DoubleArrayList)) {
            return false;
        }
        DoubleArrayList other = (DoubleArrayList)obj;
        if (!Arrays.equals(this.list, other.list)) {
            return false;
        }
        return this.size == other.size;
    }

    public double get(int index) {
        if (index >= this.size || index < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.list[index];
    }

    private void halveCapacity(int times) {
        double[] newList = new double[this.list.length / (int)Math.pow(2.0, times)];
        for (int i = 0; i < newList.length; ++i) {
            newList[i] = this.list[i];
        }
        this.list = newList;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.list);
        result = 31 * result + this.size;
        return result;
    }

    public int indexOf(double v) {
        for (int i = 0; i < this.size; ++i) {
            if (this.list[i] != v) continue;
            return i;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int lastIndexOf(double v) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (this.list[i] != v) continue;
            return i;
        }
        return -1;
    }

    public double remove(int index) {
        if (index >= this.size || index < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        double value = this.list[index];
        if (index == this.size - 1) {
            this.list[index] = 0.0;
            --this.size;
        } else {
            for (int i = index; i < this.size - 1; ++i) {
                this.list[i] = this.list[i + 1];
            }
            this.list[this.size - 1] = 0.0;
            --this.size;
        }
        if (this.size <= this.list.length / 4) {
            this.halveCapacity(1);
        }
        return value;
    }

    public boolean removeValue(double v) {
        int index = this.indexOf(v);
        if (index != -1) {
            this.remove(index);
            return true;
        }
        return false;
    }

    public double set(int index, double v) {
        if (index >= this.size || index < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        double value = this.list[index];
        this.list[index] = v;
        return value;
    }

    public double size() {
        return this.size;
    }

    public double[] toArray() {
        return Arrays.copyOf(this.list, this.size);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        for (int i = 0; i < this.size; ++i) {
            sb.append(this.list[i]);
        }
        sb.append("]");
        return sb.toString();
    }

    public void trimToSize() {
        this.list = Arrays.copyOf(this.list, this.size);
    }
}

