/*
 * Decompiled with CFR 0.152.
 */
package com.robrua.easyjava.type.primitive;

import java.io.Serializable;
import java.util.Arrays;

public class IntArrayList
implements Serializable {
    private static final long serialVersionUID = 1983008541172218739L;
    private int[] list;
    private int size;

    public IntArrayList() {
        this(10);
    }

    public IntArrayList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Initial capacity must be non-negative");
        }
        this.list = new int[initialCapacity];
        this.size = 0;
    }

    public void add(int v) {
        if (this.size == this.list.length) {
            this.doubleCapacity(1);
        }
        this.list[this.size++] = v;
    }

    public void add(int index, int v) {
        if (index >= this.size || index < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.size == this.list.length) {
            this.doubleCapacity(1);
        }
        for (int i = this.size; i > index; --i) {
            this.list[i] = this.list[i - 1];
        }
        this.list[index] = v;
        ++this.size;
    }

    public void clear() {
        this.list = new int[this.list.length];
        this.size = 0;
    }

    public boolean contains(int v) {
        return this.indexOf(v) >= 0;
    }

    private void doubleCapacity(int times) {
        int[] newList = new int[this.list.length * (int)Math.pow(2.0, times)];
        for (int i = 0; i < this.list.length; ++i) {
            newList[i] = this.list[i];
        }
        this.list = newList;
    }

    public void ensureCapacity(int minCapacity) {
        if (minCapacity > this.list.length) {
            int doubleTimes = (int)Math.ceil(Math.log((double)minCapacity / (double)this.list.length) / Math.log(2.0));
            this.doubleCapacity(doubleTimes);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntArrayList)) {
            return false;
        }
        IntArrayList other = (IntArrayList)obj;
        if (!Arrays.equals(this.list, other.list)) {
            return false;
        }
        return this.size == other.size;
    }

    public int get(int index) {
        if (index >= this.size || index < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.list[index];
    }

    private void halveCapacity(int times) {
        int[] newList = new int[this.list.length / (int)Math.pow(2.0, times)];
        for (int i = 0; i < newList.length; ++i) {
            newList[i] = this.list[i];
        }
        this.list = newList;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.list);
        result = 31 * result + this.size;
        return result;
    }

    public int indexOf(int v) {
        for (int i = 0; i < this.size; ++i) {
            if (this.list[i] != v) continue;
            return i;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int lastIndexOf(int v) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (this.list[i] != v) continue;
            return i;
        }
        return -1;
    }

    public int remove(int index) {
        if (index >= this.size || index < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int value = this.list[index];
        if (index == this.size - 1) {
            this.list[index] = 0;
            --this.size;
        } else {
            for (int i = index; i < this.size - 1; ++i) {
                this.list[i] = this.list[i + 1];
            }
            this.list[this.size - 1] = 0;
            --this.size;
        }
        if (this.size <= this.list.length / 4) {
            this.halveCapacity(1);
        }
        return value;
    }

    public boolean removeValue(int v) {
        int index = this.indexOf(v);
        if (index != -1) {
            this.remove(index);
            return true;
        }
        return false;
    }

    public int set(int index, int v) {
        if (index >= this.size || index < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int value = this.list[index];
        this.list[index] = v;
        return value;
    }

    public int size() {
        return this.size;
    }

    public int[] toArray() {
        return Arrays.copyOf(this.list, this.size);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        for (int i = 0; i < this.size; ++i) {
            sb.append(this.list[i]);
        }
        sb.append("]");
        return sb.toString();
    }

    public void trimToSize() {
        this.list = Arrays.copyOf(this.list, this.size);
    }
}

