/*
 * Decompiled with CFR 0.152.
 */
package com.rollbar.jvmti;

import com.rollbar.jvmti.LocalVariable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public final class CacheFrame {
    private Method method;
    private final LocalVariable[] locals;

    public CacheFrame(Method method, LocalVariable[] locals) {
        this.method = method;
        this.locals = locals != null ? Arrays.copyOf(locals, locals.length) : null;
    }

    public Method getMethod() {
        return this.method;
    }

    public Map<String, Object> getLocals() {
        if (this.locals == null || this.locals.length == 0) {
            return null;
        }
        HashMap<String, Object> localsMap = new HashMap<String, Object>();
        for (LocalVariable localVariable : this.locals) {
            if (localVariable == null) continue;
            localsMap.put(localVariable.getName(), localVariable.getValue());
        }
        return localsMap;
    }

    public String toString() {
        return "CacheFrame{, locals=" + Arrays.toString(this.locals) + '}';
    }
}

