/*
 * Decompiled with CFR 0.152.
 */
package com.rollbar.notifier.sender;

import com.rollbar.api.payload.Payload;
import com.rollbar.notifier.sender.Sender;
import com.rollbar.notifier.sender.exception.ApiException;
import com.rollbar.notifier.sender.exception.SenderException;
import com.rollbar.notifier.sender.listener.SenderListener;
import com.rollbar.notifier.sender.listener.SenderListenerCollection;
import com.rollbar.notifier.sender.result.Response;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSender
implements Sender {
    private Logger thisLogger = LoggerFactory.getLogger(this.getClass());
    private final SenderListenerCollection listeners = new SenderListenerCollection();

    protected abstract Response doSend(Payload var1) throws Exception;

    @Override
    public final void send(Payload payload) {
        try {
            Response response = this.doSend(payload);
            if (response.getResult().isError()) {
                this.notifyError(payload, new SenderException(new ApiException(response)));
            } else {
                this.notifyResult(payload, response);
            }
        }
        catch (Exception e) {
            this.notifyError(payload, new SenderException(e));
        }
    }

    @Override
    public final void addListener(SenderListener listener) {
        this.listeners.addListener(listener);
    }

    @Override
    public final List<SenderListener> getListeners() {
        return this.listeners.getListeners();
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void close(boolean wait) throws Exception {
        this.close();
    }

    private void notifyResult(Payload payload, Response response) {
        this.thisLogger.debug("Payload sent uuid: {}", (Object)response.getResult().getContent());
        this.listeners.onResponse(payload, response);
    }

    private void notifyError(Payload payload, Exception error) {
        this.thisLogger.error("Error sending the payload.", (Throwable)error);
        this.listeners.onError(payload, error);
    }
}

