/*
 * Decompiled with CFR 0.152.
 */
package com.rollbar.notifier.sender.queue;

import com.rollbar.api.payload.Payload;
import com.rollbar.notifier.util.ObjectsUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskQueue
extends AbstractQueue<Payload> {
    private static Logger LOGGER = LoggerFactory.getLogger(DiskQueue.class);
    private static final int UNBOUNDED_QUEUE = 0;
    private static final String QUEUE_FOLDER = ".rollbar-queue";
    private static final String FILENAME_SUFFIX = "payload";
    private static final String FILENAME_NAME_FORMAT = "%s.%s";
    private final File queueFolder;
    private final int maxSize;

    private DiskQueue(Builder builder) {
        this.maxSize = builder.maxSize;
        this.queueFolder = builder.queueFolder;
        if (!this.queueFolder.exists() && !this.queueFolder.mkdirs()) {
            LOGGER.error("Could not create folder: {}", (Object)this.queueFolder);
        }
        if (!this.queueFolder.canRead() || !this.queueFolder.canWrite()) {
            LOGGER.error("Not enough permissions folder: {}", (Object)this.queueFolder);
        }
    }

    @Override
    public Iterator<Payload> iterator() {
        return new PayloadIterator(this.getFiles().iterator());
    }

    @Override
    public int size() {
        return this.getFiles().size();
    }

    @Override
    public boolean offer(Payload payload) {
        if (this.isFull()) {
            return false;
        }
        this.writeToFile(payload);
        return true;
    }

    @Override
    public Payload poll() {
        return this.readFromFile(true);
    }

    @Override
    public Payload peek() {
        return this.readFromFile(false);
    }

    private void writeToFile(Payload payload) {
        ObjectOutputStream objectOut = null;
        File file = new File(this.queueFolder.getAbsolutePath(), DiskQueue.createFilename(payload));
        try {
            objectOut = new ObjectOutputStream(new FileOutputStream(file));
            objectOut.writeObject(payload);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                ObjectsUtils.close(objectOut);
                throw throwable;
            }
        }
        ObjectsUtils.close(objectOut);
    }

    private boolean isFull() {
        if (this.maxSize <= 0) {
            return false;
        }
        return this.size() >= this.maxSize;
    }

    private Payload readFromFile(boolean removeFile) {
        List<File> files = this.getFiles();
        if (files.size() > 0) {
            File eventFile = this.getFiles().get(0);
            return DiskQueue.read(eventFile, removeFile);
        }
        return null;
    }

    private List<File> getFiles() {
        File[] files = this.queueFolder.listFiles();
        if (files == null) {
            return Collections.emptyList();
        }
        ArrayList<File> payloads = new ArrayList<File>();
        for (File file : files) {
            if (!file.getName().endsWith(FILENAME_SUFFIX)) continue;
            payloads.add(file);
        }
        return payloads;
    }

    private static String createFilename(Payload payload) {
        String uuid = payload.getData() != null && payload.getData().getUuid() != null ? payload.getData().getUuid() : UUID.randomUUID().toString();
        return String.format(FILENAME_NAME_FORMAT, uuid, FILENAME_SUFFIX);
    }

    private static Payload read(File file, boolean remove) {
        ObjectInputStream objectInput = null;
        boolean error = false;
        try {
            objectInput = new ObjectInputStream(new FileInputStream(file));
            Object o = objectInput.readObject();
            Payload payload = (Payload)o;
            return payload;
        }
        catch (Exception e) {
            error = true;
            throw new RuntimeException(e);
        }
        finally {
            if ((remove || error) && !file.delete()) {
                LOGGER.error("Can not delete the file: {}", (Object)file.getPath());
            }
            ObjectsUtils.close(objectInput);
        }
    }

    static final class PayloadIterator
    implements Iterator<Payload> {
        private final Iterator<File> it;

        public PayloadIterator(Iterator<File> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Payload next() {
            return DiskQueue.read(this.it.next(), false);
        }

        @Override
        public void remove() {
            this.it.remove();
        }
    }

    public static final class Builder {
        private File queueFolder;
        private int maxSize = 0;

        public Builder maxSize(int maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public Builder queueFolder(File queueFolder) {
            this.queueFolder = queueFolder;
            return this;
        }

        public DiskQueue build() {
            if (this.queueFolder == null) {
                this.queueFolder = new File(DiskQueue.QUEUE_FOLDER);
            }
            return new DiskQueue(this);
        }
    }
}

