/*
 * Decompiled with CFR 0.152.
 */
package com.rollbar.notifier.telemetry;

import com.rollbar.api.payload.data.Level;
import com.rollbar.api.payload.data.Source;
import com.rollbar.api.payload.data.TelemetryEvent;
import com.rollbar.api.payload.data.TelemetryType;
import com.rollbar.notifier.provider.Provider;
import com.rollbar.notifier.telemetry.TelemetryEventTracker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class RollbarTelemetryEventTracker
implements TelemetryEventTracker {
    public static final int MAXIMUM_CAPACITY_FOR_TELEMETRY_EVENTS = 100;
    private final int maximumTelemetryData;
    private final Queue<TelemetryEvent> telemetryEvents = new ConcurrentLinkedQueue<TelemetryEvent>();
    private final Provider<Long> timestampProvider;
    private static final String LOG_KEY_MESSAGE = "message";
    private static final String NAVIGATION_KEY_FROM = "from";
    private static final String NAVIGATION_KEY_TO = "to";
    private static final String NETWORK_KEY_METHOD = "method";
    private static final String NETWORK_KEY_URL = "url";
    private static final String NETWORK_KEY_STATUS_CODE = "status_code";
    private static final int NO_CAPACITY = 0;

    public RollbarTelemetryEventTracker(Provider<Long> timestampProvider, int maximumTelemetryData) {
        this.maximumTelemetryData = maximumTelemetryData < 0 ? 0 : Math.min(maximumTelemetryData, 100);
        this.timestampProvider = timestampProvider;
    }

    @Override
    public List<TelemetryEvent> dump() {
        ArrayList<TelemetryEvent> events = new ArrayList<TelemetryEvent>(this.telemetryEvents);
        this.telemetryEvents.clear();
        return events;
    }

    @Override
    public void recordLogEventFor(Level level, Source source, String message) {
        HashMap<String, String> body = new HashMap<String, String>();
        body.put(LOG_KEY_MESSAGE, message);
        this.addEvent(new TelemetryEvent(TelemetryType.LOG, level, Long.valueOf(this.getTimestamp()), source, body));
    }

    @Override
    public void recordManualEventFor(Level level, Source source, String message) {
        HashMap<String, String> body = new HashMap<String, String>();
        body.put(LOG_KEY_MESSAGE, message);
        this.addEvent(new TelemetryEvent(TelemetryType.MANUAL, level, Long.valueOf(this.getTimestamp()), source, body));
    }

    @Override
    public void recordNavigationEventFor(Level level, Source source, String from, String to) {
        HashMap<String, String> body = new HashMap<String, String>();
        body.put(NAVIGATION_KEY_FROM, from);
        body.put(NAVIGATION_KEY_TO, to);
        this.addEvent(new TelemetryEvent(TelemetryType.NAVIGATION, level, Long.valueOf(this.getTimestamp()), source, body));
    }

    @Override
    public void recordNetworkEventFor(Level level, Source source, String method, String url, String statusCode) {
        HashMap<String, String> body = new HashMap<String, String>();
        body.put(NETWORK_KEY_METHOD, method);
        body.put(NETWORK_KEY_URL, url);
        body.put(NETWORK_KEY_STATUS_CODE, statusCode);
        this.addEvent(new TelemetryEvent(TelemetryType.NETWORK, level, Long.valueOf(this.getTimestamp()), source, body));
    }

    private void addEvent(TelemetryEvent telemetryEvent) {
        if (this.doNotRecordEvents()) {
            return;
        }
        if (this.maxCapacityReached()) {
            this.removeOldestEvent();
        }
        this.telemetryEvents.add(telemetryEvent);
    }

    private boolean doNotRecordEvents() {
        return this.maximumTelemetryData == 0;
    }

    private boolean maxCapacityReached() {
        return this.telemetryEvents.size() >= this.maximumTelemetryData;
    }

    private void removeOldestEvent() {
        this.telemetryEvents.poll();
    }

    private long getTimestamp() {
        return this.timestampProvider.provide();
    }
}

