/*
 * Decompiled with CFR 0.152.
 */
package com.rollbar.notifier.util;

import com.rollbar.api.payload.data.TelemetryEvent;
import com.rollbar.api.payload.data.body.Body;
import com.rollbar.api.payload.data.body.BodyContent;
import com.rollbar.api.payload.data.body.ExceptionInfo;
import com.rollbar.api.payload.data.body.Frame;
import com.rollbar.api.payload.data.body.Message;
import com.rollbar.api.payload.data.body.Trace;
import com.rollbar.api.payload.data.body.TraceChain;
import com.rollbar.jvmti.CacheFrame;
import com.rollbar.jvmti.ThrowableCache;
import com.rollbar.notifier.wrapper.RollbarThrowableWrapper;
import com.rollbar.notifier.wrapper.ThrowableWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BodyFactory {
    @Deprecated
    public Body from(Throwable throwable, String description) {
        if (throwable == null) {
            return new Body.Builder().bodyContent((BodyContent)BodyFactory.message(description)).build();
        }
        return this.from(new RollbarThrowableWrapper(throwable), description);
    }

    public Body from(ThrowableWrapper throwableWrapper, String description) {
        Body.Builder builder = new Body.Builder();
        return this.from(throwableWrapper, description, builder);
    }

    public Body from(ThrowableWrapper throwableWrapper, String description, List<TelemetryEvent> telemetryEvents) {
        Body.Builder builder = new Body.Builder().telemetryEvents(telemetryEvents);
        return this.from(throwableWrapper, description, builder);
    }

    private Body from(ThrowableWrapper throwableWrapper, String description, Body.Builder builder) {
        if (throwableWrapper == null) {
            return builder.bodyContent((BodyContent)BodyFactory.message(description)).build();
        }
        if (throwableWrapper.getCause() == null) {
            return builder.bodyContent((BodyContent)BodyFactory.trace(throwableWrapper, description)).build();
        }
        return builder.bodyContent((BodyContent)BodyFactory.traceChain(throwableWrapper, description)).build();
    }

    private static Message message(String description) {
        return new Message.Builder().body(description).build();
    }

    private static Trace trace(ThrowableWrapper throwableWrapper, String description) {
        return new Trace.Builder().frames(BodyFactory.frames(throwableWrapper)).exception(BodyFactory.info(throwableWrapper, description)).build();
    }

    private static TraceChain traceChain(ThrowableWrapper throwableWrapper, String description) {
        ArrayList<Trace> chain = new ArrayList<Trace>();
        do {
            chain.add(BodyFactory.trace(throwableWrapper, description));
            description = null;
        } while ((throwableWrapper = throwableWrapper.getCause()) != null);
        return new TraceChain.Builder().traces(chain).build();
    }

    private static List<Frame> frames(ThrowableWrapper throwableWrapper) {
        StackTraceElement[] elements = throwableWrapper.getStackTrace();
        CacheFrame[] cachedFrames = ThrowableCache.get(throwableWrapper.getThrowable());
        int j = 0;
        if (cachedFrames != null) {
            j = cachedFrames.length - 1;
        }
        ArrayList<Frame> result = new ArrayList<Frame>();
        int i = elements.length - 1;
        while (i >= 0) {
            StackTraceElement element = elements[i];
            Map<String, Object> locals = null;
            if (cachedFrames != null) {
                while (j >= 0 && !cachedFrames[j].getMethod().getName().equals(element.getMethodName())) {
                    --j;
                }
                if (j >= 0) {
                    locals = cachedFrames[j].getLocals();
                }
            }
            result.add(BodyFactory.frame(element, locals));
            --i;
            --j;
        }
        return result;
    }

    private static ExceptionInfo info(ThrowableWrapper throwableWrapper, String description) {
        String className = throwableWrapper.getClassName();
        String message = throwableWrapper.getMessage();
        return new ExceptionInfo.Builder().className(className).message(message).description(description).build();
    }

    private static Frame frame(StackTraceElement element, Map<String, Object> locals) {
        String filename = element.getFileName();
        Integer lineNumber = element.getLineNumber();
        String method = element.getMethodName();
        String className = element.getClassName();
        return new Frame.Builder().filename(filename).lineNumber(lineNumber).method(method).className(className).locals(locals).build();
    }
}

