/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.config;

import com.appland.appmap.config.AppMapPackage;
import com.appland.appmap.util.Logger;
import com.appland.shade.org.yaml.snakeyaml.Yaml;
import com.appland.shade.org.yaml.snakeyaml.error.YAMLException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;

public class AppMapConfig {
    public String name;
    public AppMapPackage[] packages = new AppMapPackage[0];
    private static AppMapConfig singleton = new AppMapConfig();

    public static AppMapConfig load(File configFile) {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(configFile);
        }
        catch (FileNotFoundException e) {
            Logger.println(String.format("error: file not found -> %s", configFile.getPath()));
            return null;
        }
        Yaml yaml = new Yaml();
        try {
            singleton = yaml.loadAs(inputStream, AppMapConfig.class);
        }
        catch (YAMLException e) {
            System.err.println("AppMap: encountered syntax error in appmap.yml " + e.getMessage());
            System.exit(1);
        }
        return singleton;
    }

    public static AppMapConfig get() {
        return singleton;
    }

    public Boolean includes(String canonicalName) {
        if (this.packages == null) {
            return false;
        }
        for (AppMapPackage pkg : this.packages) {
            if (!pkg.includes(canonicalName).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public Boolean excludes(String canonicalName) {
        if (this.packages == null) {
            return false;
        }
        for (AppMapPackage pkg : this.packages) {
            if (!pkg.excludes(canonicalName).booleanValue()) continue;
            return true;
        }
        return false;
    }
}

