/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.integration;

import com.appland.appmap.config.Properties;
import com.appland.appmap.record.ActiveSessionException;
import com.appland.appmap.record.Recorder;
import com.appland.appmap.test.util.MyClass;
import com.appland.shade.org.junit.Assert;
import com.appland.shade.org.junit.Test;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;

public class RecorderTest {
    private static final Recorder recorder = Recorder.getInstance();

    @Test
    public void testRecordBlock() {
        MyClass myClass = new MyClass();
        String scenario = recorder.record(() -> {
            for (int i = 0; i < 10; ++i) {
                myClass.myMethod();
            }
        });
        Assert.assertNotNull(scenario);
    }

    @Test
    public void testRecordBlockToFile() throws IOException {
        MyClass myClass = new MyClass();
        File output = new File(Paths.get(Properties.OutputDirectory, "Recording_a_block_to_a_file.appmap.json").toString());
        if (output.exists()) {
            output.delete();
        }
        recorder.record("Recording a block to a file", () -> {
            for (int i = 0; i < 10; ++i) {
                myClass.myMethod();
            }
        });
        Assert.assertTrue(output.exists());
    }

    @Test(timeout=5000L)
    public void testMultiThreadedRecordBlock() throws IOException, InterruptedException {
        int iterations = 1000;
        MyClass myClass = new MyClass();
        Thread t = new Thread(() -> {
            for (int i = 0; i < 1000; ++i) {
                try {
                    recorder.record(() -> myClass.myMethod());
                    continue;
                }
                catch (ActiveSessionException activeSessionException) {
                    // empty catch block
                }
            }
        });
        t.start();
        for (int i = 0; i < 1000; ++i) {
            try {
                recorder.record(() -> myClass.myMethod());
                continue;
            }
            catch (ActiveSessionException activeSessionException) {
                // empty catch block
            }
        }
        t.join();
        Assert.assertFalse(recorder.hasActiveSession());
    }
}

