/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.integration;

import com.appland.appmap.test.util.MyClass;
import com.appland.appmap.test.util.MyThread;
import com.appland.appmap.test.util.UnhandledExceptionCollection;
import com.appland.shade.org.junit.Assert;
import com.appland.shade.org.junit.Test;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;

public class ThreadTest {
    @Test
    public void testHookingThreadSubclassDoesNotOverflowStack() throws InterruptedException {
        MyThread t = new MyThread(() -> {
            MyClass myClass = new MyClass();
            myClass.myMethod();
        });
        UnhandledExceptionCollection exceptions = new UnhandledExceptionCollection();
        t.setUncaughtExceptionHandler(exceptions);
        t.start();
        t.join();
        Assert.assertFalse(exceptions.contains(StackOverflowError.class));
    }

    @Test
    public void testConcurrentModificationNonUniqueThreadId() throws InterruptedException {
        Runnable r = () -> {
            MyClass myClass = new MyClass();
            for (int i = 0; i < 1000; ++i) {
                myClass.myMethod();
            }
        };
        long sharedThreadId = 100L;
        int numThreads = 8;
        UnhandledExceptionCollection exceptions = new UnhandledExceptionCollection();
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (int i = 0; i < 8; ++i) {
            Thread t = new MyThread(100L, r);
            t.setUncaughtExceptionHandler(exceptions);
            threads.add(t);
            t.start();
        }
        for (Thread t : threads) {
            t.join();
        }
        Assert.assertFalse(exceptions.contains(ConcurrentModificationException.class));
    }
}

