/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.output.v1;

import com.appland.appmap.util.Logger;
import com.appland.shade.com.alibaba.fastjson.annotation.JSONField;
import com.appland.shade.javassist.CtBehavior;
import com.appland.shade.javassist.CtClass;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class CodeObject {
    public String name = "";
    public String type = "";
    @JSONField(name="static")
    public Boolean isStatic;
    private ArrayList<CodeObject> children = null;
    @JSONField(serialize=false, deserialize=false)
    private String file;
    @JSONField(serialize=false, deserialize=false)
    private Integer lineno;

    public CodeObject setName(String name) {
        this.name = name;
        return this;
    }

    public CodeObject setType(String type) {
        this.type = type;
        return this;
    }

    public CodeObject setStatic(Boolean isStatic) {
        this.isStatic = isStatic;
        return this;
    }

    @JSONField(name="location")
    public String getLocation() {
        String ret;
        String string = ret = this.file != null ? this.file : null;
        if (ret != null && this.lineno != null) {
            ret = ret + ":" + this.lineno;
        }
        return ret;
    }

    public CodeObject setLocation(String location) {
        int colonIdx = location.indexOf(58);
        this.file = location.substring(0, colonIdx);
        this.lineno = colonIdx + 1;
        return this;
    }

    public List<CodeObject> getChildren() {
        return this.children;
    }

    public List<CodeObject> safeGetChildren() {
        return this.children != null ? this.children : Collections.emptyList();
    }

    private CodeObject setFile(String file) {
        this.file = file;
        return this;
    }

    private CodeObject setLineno(Integer lineno) {
        this.lineno = lineno;
        return this;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CodeObject)) {
            return false;
        }
        CodeObject codeObject = (CodeObject)obj;
        return codeObject.type == this.type && codeObject.name.equals(this.name) && codeObject.isStatic == this.isStatic && (codeObject.file == null ? this.file == null : codeObject.file.equals(this.file)) && codeObject.lineno == this.lineno;
    }

    public CodeObject() {
    }

    public CodeObject(Package pkg) {
        this.setType("package").setName(pkg.getName());
    }

    public CodeObject(CtClass classType) {
        this.setType("class").setFile(CodeObject.getSourceFilePath(classType)).setName(classType.getSimpleName()).setStatic((classType.getModifiers() & 8) != 0);
    }

    public CodeObject(CtBehavior behavior) {
        String file = CodeObject.getSourceFilePath(behavior.getDeclaringClass());
        int lineno = behavior.getMethodInfo().getLineNumber(0);
        this.setType("function").setName(behavior.getName()).setFile(file).setLineno(lineno).setStatic((behavior.getModifiers() & 8) != 0);
    }

    public CodeObject(CodeObject src) {
        this.setType(src.type).setName(src.name).setStatic(src.isStatic).setFile(src.file).setLineno(src.lineno);
    }

    public static String getSourceFilePath(CtClass classType) {
        CharSequence[] parts = new String[]{"src", "main", "java", classType.getPackageName().replace('.', '/'), classType.getClassFile().getSourceFile()};
        return String.join((CharSequence)"/", parts);
    }

    public static CodeObject createTree(String packageName) {
        String[] packageTokens = packageName.split("\\.");
        CodeObject rootObject = null;
        CodeObject previousObject = null;
        for (String token : packageTokens) {
            CodeObject pkgObject = new CodeObject().setType("package").setName(token);
            if (rootObject == null) {
                rootObject = pkgObject;
            }
            if (previousObject != null) {
                previousObject.addChild(pkgObject);
            }
            previousObject = pkgObject;
        }
        return rootObject;
    }

    public static CodeObject createTree(CtClass classType) {
        String packageName = classType.getPackageName();
        CodeObject rootObject = CodeObject.createTree(packageName);
        CodeObject pkgLeafObject = rootObject.get(packageName);
        if (pkgLeafObject == null) {
            Logger.println("failed to get leaf pkg object for package " + packageName);
            return null;
        }
        CodeObject classObj = new CodeObject(classType);
        pkgLeafObject.addChild(classObj);
        return rootObject;
    }

    public static CodeObject createTree(CtBehavior method) {
        CtClass classType = method.getDeclaringClass();
        CodeObject rootObject = CodeObject.createTree(classType);
        CodeObject classObject = rootObject.get(classType.getName());
        if (classObject == null) {
            Logger.println("failed to get class object for package " + classType.getPackageName());
            return null;
        }
        CodeObject methodObject = new CodeObject(method);
        classObject.addChild(methodObject);
        return rootObject;
    }

    private CodeObject get(ArrayDeque<String> tokens) {
        String currentToken = tokens.peek();
        if (currentToken == null) {
            return null;
        }
        if (currentToken.equals(this.name)) {
            tokens.pop();
            if (tokens.isEmpty()) {
                return this;
            }
            for (CodeObject child : this.safeGetChildren()) {
                CodeObject match = child.get(tokens);
                if (match == null) continue;
                return match;
            }
        }
        return null;
    }

    public CodeObject get(String path) {
        List<String> tokens = Arrays.asList(path.split("\\."));
        return this.get(new ArrayDeque<String>(tokens));
    }

    public CodeObject findChild(String name, Boolean isStatic, int lineNumber) {
        for (CodeObject child : this.safeGetChildren()) {
            if (!child.name.equals(name) || child.isStatic != isStatic || child.lineno != lineNumber) continue;
            return child;
        }
        return null;
    }

    public CodeObject findChild(String name) {
        for (CodeObject child : this.safeGetChildren()) {
            if (!child.name.equals(name)) continue;
            return child;
        }
        return null;
    }

    private boolean equalBySubstring(String s1, String s2, int start, int end) {
        int sublen = end - start;
        if (s1.length() != sublen) {
            return false;
        }
        for (int idx = 0; idx < sublen; ++idx) {
            if (s1.charAt(idx) == s2.charAt(start + idx)) continue;
            return false;
        }
        return true;
    }

    public CodeObject findChildBySubstring(String name, int start, int end) {
        for (CodeObject child : this.safeGetChildren()) {
            if (!this.equalBySubstring(child.name, name, start, end)) continue;
            return child;
        }
        return null;
    }

    public CodeObject addChild(CodeObject child) {
        if (child == null) {
            return this;
        }
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(child);
        return this;
    }
}

